<?php
$kopa_data_icon = '&#xe07b;'; // icon-music
?>
<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

    <header>
        <span class="entry-categories"><span data-icon="&#xe131;"></span><?php the_category( ', ' ); ?></span>
        <span class="entry-box-icon" data-icon="<?php echo $kopa_data_icon; ?>"></span>
        <div class="entry-box-title clearfix">
            <h4 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
            <div class="meta-box">
                <span class="entry-date"><?php the_time( get_option( 'date_format' ) ); ?></span>
                <span class="entry-author"><?php _e( 'By', kopa_get_domain() ); ?> <?php the_author_posts_link(); ?></span>
                <span class="entry-comments"><span data-icon="&#xe0d0;"></span><?php ?><?php comments_popup_link( '0', '1', '%', '', __( 'Off', kopa_get_domain() ) ); ?></span>
                <?php 
                $kopa_total_view = get_post_meta( get_the_ID(), 'kopa_' . kopa_get_domain() . '_total_view', true );

                if ( 'show' == get_option('kopa_theme_options_view_count_status', 'show') && $kopa_total_view ) {
                ?>
                    <span class="entry-view"><span data-icon="&#xe02b;"></span><?php echo $kopa_total_view; ?></span>
                <?php } // endif ?>
            </div>
            <!-- meta-box -->
            <?php 
            $post_rating = round( get_post_meta( get_the_ID(), 'kopa_editor_user_total_all_rating_' . kopa_get_domain(), true ) );

            if ( ! empty( $post_rating ) ) {
            ?>
                <ul class="kopa-rating clearfix">
                    <?php
                    for ( $i = 0; $i < $post_rating; $i++ ) {
                        echo '<li><span data-icon="&#xe131;"></span></li>';
                    }
                    for ( $i = 0; $i < 5 - $post_rating; $i++ ) {
                        echo '<li><span data-icon="&#xe12f;"></span></li>';
                    }
                    ?>
                </ul>
            <?php } ?>
            <div class="clear"></div>
        </div>
        <!-- entry-box-title -->
        <div class="clear"></div>
    </header>

    <div class="entry-thumb">
        <?php 
        $audio = kopa_content_get_audio( get_the_content() );
        if ( isset( $audio[0] ) ) {
            $audio = $audio[0];
        } else {
            $audio = '';
        }

        if ( isset( $audio['shortcode'] ) ) {
            echo do_shortcode( $audio['shortcode'] );
        }
        ?>
    </div>

    <div class="elements-box">
        <?php $content = get_the_content(); 
        $content = preg_replace( '/\[audio].*\[\/audio]/', '', $content );
        $content = preg_replace( '/\[soundcloud].*\[\/soundcloud]/', '', $content );
        $content = apply_filters( 'the_content', $content );
        $content = str_replace(']]>', ']]&gt;', $content);
        echo $content;
        ?>
    </div>
    <div class="clear"></div>

    <div class="wp-link-pages clearfix">
        <?php wp_link_pages( array(
            'before'   => '<p>',
            'after'    => '</p>',
            'pagelink' => __( 'Page %', kopa_get_domain() )
        ) ); ?>
    </div> <!-- .wp-link-pages -->

    <?php get_template_part( 'library/templates/template', 'post-rating' ); ?>
    <!-- post-rating -->

    <?php kopa_get_socials_link(); ?>
    <!-- social-link -->
    
    <footer class="clearfix">
        <?php get_template_part( 'library/templates/template', 'post-navigation' ); ?>
    </footer>
</div>
<!-- entry-box -->