<?php
$kopa_data_icon = '&#xe070;'; // icon-pencil
$kopa_display_featured_image = get_option( 'kopa_theme_options_featured_image_status', 'show' );
$kopa_post_thumbnail_style = get_option( 'kopa_theme_options_post_thumbnail_style', 'large' );

if ( 'small' == $kopa_post_thumbnail_style && 'show' == $kopa_display_featured_image && has_post_thumbnail() ) {
    echo '<div class="kopa-single-2">';
} // endif
?>
    <div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

        <?php if ( 'show' == $kopa_display_featured_image && 'small' == $kopa_post_thumbnail_style && has_post_thumbnail() ) { ?>
            <div class="entry-thumb">
                <?php the_post_thumbnail( 'kopa-image-size-8' ); // 795 x 429 ?>
            </div>
        <?php } // endif ?>

        <header>
            <span class="entry-categories"><span data-icon="&#xe131;"></span><?php the_category( ', ' ); ?></span>
            <span class="entry-box-icon" data-icon="<?php echo $kopa_data_icon; ?>"></span>
            <div class="entry-box-title clearfix">
                <h4 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                <div class="meta-box">
                    <span class="entry-date"><?php the_time( get_option( 'date_format' ) ); ?></span>
                    <span class="entry-author"><?php _e( 'By', kopa_get_domain() ); ?> <?php the_author_posts_link(); ?></span>
                    <span class="entry-comments"><span data-icon="&#xe0d0;"></span><?php ?><?php comments_popup_link( '0', '1', '%', '', __( 'Off', kopa_get_domain() ) ); ?></span>
                    <?php 
                    $kopa_total_view = get_post_meta( get_the_ID(), 'kopa_' . kopa_get_domain() . '_total_view', true );

                    if ( 'show' == get_option('kopa_theme_options_view_count_status', 'show') && $kopa_total_view ) {
                    ?>
                        <span class="entry-view"><span data-icon="&#xe02b;"></span><?php echo $kopa_total_view; ?></span>
                    <?php } // endif ?>
                </div>
                <!-- meta-box -->
                <?php 
                $post_rating = round( get_post_meta( get_the_ID(), 'kopa_editor_user_total_all_rating_' . kopa_get_domain(), true ) );

                if ( ! empty( $post_rating ) ) {
                ?>
                    <ul class="kopa-rating clearfix">
                        <?php
                        for ( $i = 0; $i < $post_rating; $i++ ) {
                            echo '<li><span data-icon="&#xe131;"></span></li>';
                        }
                        for ( $i = 0; $i < 5 - $post_rating; $i++ ) {
                            echo '<li><span data-icon="&#xe12f;"></span></li>';
                        }
                        ?>
                    </ul>
                <?php } ?>
                <div class="clear"></div>
            </div>
            <!-- entry-box-title -->
            <div class="clear"></div>
        </header>
        <?php if ( 'show' == $kopa_display_featured_image && 'large' == $kopa_post_thumbnail_style ) { ?>
            <div class="entry-thumb">
                <?php if ( has_post_thumbnail() ) {
                    the_post_thumbnail( 'large' ); // 795 x auto
                } ?>
            </div>
        <?php } // endif ?>

        <div class="elements-box">
            <?php the_content(); ?>
        </div>
        <div class="clear"></div>

        <div class="wp-link-pages clearfix">
            <?php wp_link_pages( array(
                'before'   => '<p>',
                'after'    => '</p>',
                'pagelink' => __( 'Page %', kopa_get_domain() )
            ) ); ?>
        </div> <!-- .wp-link-pages -->

        <?php get_template_part( 'library/templates/template', 'post-rating' ); ?>
        <!-- post-rating -->

        <?php kopa_get_socials_link(); ?>
        <!-- social-link -->
        
        <footer class="clearfix">
            <?php get_template_part( 'library/templates/template', 'post-navigation' ); ?>
        </footer>
    </div>
    <!-- entry-box -->

<?php 
if ( 'small' == $kopa_post_thumbnail_style && 'show' == $kopa_display_featured_image && has_post_thumbnail() ) {
    echo '</div> <!-- .kopa-single-2 -->';
} // endif
?>