<?php
/* Template Name: Contribute
 * 作者：李新站长
 * 修改：新发现工作室
 */
get_header();
if( isset($_POST['tougao_form']) && $_POST['tougao_form'] == 'send'){
    global $wpdb;
    $last_post = $wpdb->get_var("SELECT post_date FROM $wpdb->posts WHERE post_type = 'post' ORDER BY post_date DESC LIMIT 1");

    // 博客当前最新文章发布时间与要投稿的文章至少间隔120秒。
    // 可自行修改时间间隔，修改下面代码中的120即可
    // 相比Cookie来验证两次投稿的时间差，读数据库的方式更加安全
    if ( current_time('timestamp') - strtotime($last_post) < 120 ){
        wp_die('您投稿也太勤快了吧，先歇会儿！');
    }

    // 表单变量初始化
    $name = isset( $_POST['tougao_authorname'] ) ? trim(htmlspecialchars($_POST['tougao_authorname'], ENT_QUOTES)) : '';
    $email =  isset( $_POST['tougao_authoremail'] ) ? trim(htmlspecialchars($_POST['tougao_authoremail'], ENT_QUOTES)) : '';
    $blog =  isset( $_POST['tougao_authorblog'] ) ? trim(htmlspecialchars($_POST['tougao_authorblog'], ENT_QUOTES)) : '';
    $title =  isset( $_POST['tougao_title'] ) ? trim(htmlspecialchars($_POST['tougao_title'], ENT_QUOTES)) : '';
    $category =  isset( $_POST['cat'] ) ? (int)$_POST['cat'] : 0;
    $content =  isset( $_POST['tougao_content'] ) ? trim(htmlspecialchars($_POST['tougao_content'], ENT_QUOTES)) : '';
    $tags = isset( $_POST['tougao_tags'] ) ? $_POST['tougao_tags'] : '';

    // 表单项数据验证
    if ( empty($name) || mb_strlen($name) > 20 ){
        wp_die('昵称必须填写，且长度不得超过20字 <a href="javascript:;" onclick=\'location.href="javascript:history.go(-1);"\'>返回填写</a>');
    }

    if ( empty($email) || strlen($email) > 60 || !preg_match("/^([a-z0-9\+_\-]+)(\.[a-z0-9\+_\-]+)*@([a-z0-9\-]+\.)+[a-z]{2,6}$/ix", $email)){
        wp_die('Email必须填写，且长度不得超过60字，必须符合Email格式 <a href="javascript:;" onclick=\'location.href="javascript:history.go(-1);"\'>返回填写</a>');
    }

    if ( empty($title) || mb_strlen($title) > 100 ){
        wp_die('标题必须填写，且长度不得超过100字 <a href="javascript:;" onclick=\'location.href="javascript:history.go(-1);"\'>返回填写</a>');
    }

    if ( empty($content) || mb_strlen($content) > 3000 || mb_strlen($content) < 100){
        wp_die('内容必须填写，且长度不得超过3000字，不得少于100字 <a href="javascript:;" onclick=\'location.href="javascript:history.go(-1);"\'>返回填写</a>');
    }

    $post_content = '昵称: '.$name.'<br />邮箱: '.$email.'<br />blog: '.$blog.'<br />内容:<br />'.$content;

    $tougao = array(
        'post_title' => $title,
        'post_content' => $post_content,
        'tags_input' => $tags,
        'post_category' => array($category)
    );

 
    // 将文章插入数据库
    $status = wp_insert_post( $tougao );

    if ($status != 0) {
        // 投稿成功给博主发送邮件
        // somebody#example.com替换博主邮箱
        // My subject替换为邮件标题，content替换为邮件内容
        wp_mail( get_bloginfo('admin_email'),"[".get_bloginfo('name')."] 有用户投稿","有用户到您的站点投稿，请登录审核。");
        add_post_meta($status, 'tougao_authoremail', $email , TRUE);

        wp_die('投稿成功！您的文章将在审核通过后发布！','投稿成功！');
    }
    else {
        wp_die('投稿失败！');
    }
}
?>
<div id="content" style="max-width:990px;float:none;">
<div class="main" style="margin-right:0;">
<div style="display:none;"><?php if(!get_option('ini_bulletin') && get_option('ini_admin')){} else {include('includes/map.php');};?></div>
<?php if (have_posts()): while (have_posts()): the_post();?>
<h2 style="text-align:center;"><?php the_title();?></h2>
<div class="context">
<?php the_content(); ?>
<form method="post" action="<?php echo $_SERVER["REQUEST_URI"]; ?>">
    <div style="text-align: left; padding-top:50px;">
        <label for="tougao_authorname">昵称：</label>
        <input type="text" size="30" value="" id="tougao_authorname" name="tougao_authorname" /> *
    </div>

    <div style="text-align: left; padding-top:10px;">
        <label for="tougao_authoremail">邮箱：</label>
        <input type="text" size="30" value="" id="tougao_authoremail" name="tougao_authoremail" /> *
    </div>

    <div style="text-align: left; padding-top:10px;">
        <label for="tougao_authorblog">来源：</label>
        <input type="text" size="30" value="" id="tougao_authorblog" name="tougao_authorblog" />
    </div>

    <div style="text-align: left; padding-top:10px;">
        <label for="tougao_title">标题：</label>
        <input type="text" size="60" value="" id="tougao_title" name="tougao_title" />
    </div>

    <div style="text-align: left; padding-top:10px;">
        <label for="tougaocategorg">分类：</label>
        <?php wp_dropdown_categories('show_option_none=请选择文章分类&id=tougao-cat&show_count=1&hierarchical=1&hide_empty=0'); ?>
    </div>

    <div style="text-align: left; padding-top:10px;">
        <label>标签：</label>
        <input type="text" size="60" value="" name="tougao_tags" /> (请用顿号隔开)
    </div>

    <div style="text-align: left; padding-top:20px;">
        <textarea rows="15" cols="" id="tougao_content" name="tougao_content" style="padding:1%;width:98%;max-width:98%;"></textarea>
    </div>

    <br clear="all">
    <div style="text-align: center; padding-top:10px;">
        <input type="hidden" value="send" name="tougao_form" />
        <input type="submit" value=" 提交 " />
        <input type="reset" value=" 重填 " />
    </div>
</form>
</div>
<?php endwhile; else: endif;?>
</div>
</div>
<div class="clear"></div>
</div>
<?php get_footer();?>