<?php
include('widget/widget.php');
include("includes/meta-box.php");
include("includes/Initial-options.php");
include("includes/guide.php");
include("includes/notify.php");
remove_filter('the_content','wptexturize');
add_theme_support('custom-background',array('default-image'=>get_template_directory_uri().'/images/background.jpg'));
if( function_exists('register_nav_menus') ){register_nav_menus(array('primary' => '导航菜单'));}

//替换表情
function custom_smilies_src ($img_src,$img,$siteurl){return get_bloginfo('template_directory').'/images/smilies/'.$img;}
add_filter('smilies_src','custom_smilies_src',1,10);

//添加HTML编辑器按钮
function my_quicktags(){
wp_enqueue_script('my_quicktags', get_stylesheet_directory_uri().'/js/quicktags.js', array('quicktags'));
}
add_action('admin_print_scripts','my_quicktags');

//禁用Open Sans
class Disable_Google_Fonts{
	public function __construct(){
		add_filter('gettext_with_context',array($this,'disable_open_sans'),888,4);
	}
	public function disable_open_sans($translations,$text,$context,$domain ){
		if ('Open Sans font: on or off' == $context && 'on' == $text){
			$translations = 'off';
		}
		return $translations;
	}
}
$disable_google_fonts = new Disable_Google_Fonts;

//prettify代码高亮
if (get_option('ini_prettify')){
function strip_autoformat($text){
$no_br = preg_replace("/<br.?\/>/is","",$text);
$no_p = preg_replace("/<p>/is","",$no_br);
$no_lt = preg_replace("/</is","&lt;",$no_p);
$no_gt = preg_replace("/>/is","&gt;",$no_lt);
$no_pi = preg_replace("/&lt;\/p&gt;/is","",$no_gt);
return preg_replace("/<\/p>/is","\n",$no_pi);
}
function codetag_handler($atts,$content){
extract(shortcode_atts(array('lang' => 'default-markup','quote' => 'true','start' => null,'highlight' => null),$atts));
return "<pre class='" .
($quote == 'true' ? "" : "dontquote ") .
"prettyprint lang-$lang" .
($start != null ? " linenums:$start linenumstrigger" : "") .
($highlight != null ? " highlight:$highlight" : "") .
"'>" . strip_autoformat($content) . "</pre>";
}
add_shortcode('code','codetag_handler');
function prettify_gc_clean_code($text){
return preg_replace("/<pre\\s*class\\s*=\\s*([\"'])\\s*prettyprint\\s*([^>]*?)\\s*>(.*?)<\/pre>/ise","'<pre class='.stripslashes('$1').'prettyprint '.stripslashes('$2').'>'.htmlentities(stripslashes('$3')).'</pre>'",$text);
}
add_filter('the_content','prettify_gc_clean_code',1);
function prettify_gc_style_trigger($text){
return preg_replace("/<pre\\s*class\\s*=([^>]*?)(\\blinenums\\b)([^>]*?)\\s*>/ise","'<pre class='.stripslashes('$1').stripslashes('$2').'trigger '.stripslashes('$2').stripslashes('$3').'>'",$text);
}
add_filter('the_content','prettify_gc_style_trigger',2);
}

//浏览次数
function get_post_views ($post_id){
	$count_key = 'views';
	$count = get_post_meta($post_id,$count_key,true);
	if ($count == ''){
		delete_post_meta($post_id,$count_key);
		add_post_meta($post_id,$count_key,'0');
		$count = '0';
	}
	echo number_format_i18n($count);
}
function set_post_views (){
	global $post;
	$post_id = $post -> ID;
	$count_key = 'views';
	$count = get_post_meta($post_id,$count_key,true);
	if (is_single() || is_page()){
		if ($count == ''){
			delete_post_meta($post_id,$count_key);
			add_post_meta($post_id,$count_key,'0');
		} else{
			update_post_meta($post_id,$count_key,$count + 1);
		}
	}
}
add_action('get_header','set_post_views');

//短代码 //音乐
function cleris_music($atts, $music=null){
extract(shortcode_atts(array('autoplay'=>null,'loop'=>null), $atts));
return '<audio controls '.$autoplay.' '.$loop.' style="max-width:100%" src="'.$music.'" ><embed src='.get_bloginfo('template_url').'/includes/mplayer.swf quality="high" width="280" height="24" wmode="transparent" type="application/x-shockwave-flash" pluginspage="http://www.macromedia.com/go/getflashplayer" flashvars="bg=0xD4E8FF&leftbg=0x0DA4D3&lefticon=0xF2F2F2&rightbg=0x0DA4D3&rightbghover=0x3AB8DF&righticon=0xF2F2F2&righticonhover=0xFFFFFF&text=0x0088DD&slider=0x0088DD&track=0xFFFFFF&border=0xFFFFFF&loader=0x8EC2F4&autostart=no&loop=yes&soundFile='.$music.'"></audio>';}
//视频
function cleris_video($atts, $video=null){
return '<video controls src="'.$video.'" style="max-width:100%" ></video>';
}
//下载
function cleris_download($atts, $download=null){
extract(shortcode_atts(array('title'=>null,'href'=>null), $atts));
return '<span class="download"><a title="'.$title.'" href="'.$href.'">'.$download.'</a></span>';
}
//外链
function cleris_url($atts, $url=null){
extract(shortcode_atts(array('title'=>null,'href'=>null), $atts));
return '<span class="u-download"><a title="'.$title.'" href="'.$href.'" rel="external nofollow">'.$url.'</a></span>';
}
add_shortcode('music','cleris_music');
add_shortcode('video','cleris_video');
add_shortcode('download','cleris_download');
add_shortcode('url','cleris_url');

//公告
function post_type_bulletin(){
	register_post_type(
		'bulletin',
		array( 'public' => true,
			'publicly_queryable' => true,
			'hierarchical' => false,
			'labels'=>array(
				'name' => _x('公告', 'post type general name'),
				'singular_name' => _x('公告', 'post type singular name'),
				'add_new' => _x('添加新公告', '公告'),
				'add_new_item' => __('添加新公告'),
				'edit_item' => __('编辑公告'),
				'new_item' => __('新的公告'),
				'view_item' => __('预览公告'),
				'search_items' => __('搜索公告'),
				'not_found' =>  __('您还没有发布公告'),
				'not_found_in_trash' => __('回收站中没有公告'),
				'parent_item_colon' => ''
			),
			'show_ui' => true,
			'menu_position'=>5,
			'supports' => array(
			'title',
			'author',
			'excerpt',
			'thumbnail',
			'trackbacks',
			'editor',
			'comments',
			'custom-fields',
			'revisions'),
		)
	);
}
function custom_book_link( $link, $post = 0 ){
	if ( $post->post_type == 'bulletin' ){
		return home_url( 'bulletin/' . $post->ID .'.html' );
	} else {
		return $link;
	}
}
function custom_book_rewrites_init(){
	add_rewrite_rule(
		'bulletin/([0-9]+)?.html$',
		'index.php?post_type=bulletin&p=$matches[1]',
		'top' );
}
add_action('init', 'post_type_bulletin');
add_filter('post_type_link', 'custom_book_link', 1, 3);
add_action( 'init', 'custom_book_rewrites_init' );

//设置个人资料
function my_profile( $contactmethods ){
$contactmethods['weibo_sina'] = '新浪微博';
$contactmethods['weibo_tx'] = '腾讯微博';
$contactmethods['renren'] = '人人网';
$contactmethods['ggplus'] = 'Google+ ID';
unset($contactmethods['aim']);
unset($contactmethods['yim']);
return $contactmethods;
}
add_filter('user_contactmethods','my_profile');

//获得特色图像
function get_post_img($width=110,$height=110,$sizeTag=2){
global $post,$posts;$first_img ='';$output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i',$post->post_content,$matches);$first_img = '<img src="'. $matches[1][0] .'" width="'.$width.'" height="'.$height.'" alt="'.$post->post_title .'"/>';if(empty($matches[1][0])){if($sizeTag == 2){
			$first_img = '<img src="'. get_bloginfo('template_url') .'/images/random/small'.rand(1,10).'.jpg" alt="'.$post->post_title .'" width="'.$width.'" height="'.$height.'"/>';
		} else{
			$first_img = '<img src="'. get_bloginfo('template_url') .'/images/random/big'.rand(1,7).'.jpg" alt="'.$post->post_title .'" width="'.$width.'" height="'.$height.'"/>';
		}
	}
return $first_img;
}

//输出特色图像
function get_img($width,$height,$size){?>
<div class="thumbnail_box bd">
<div class="thumbnail">
<a href="<?php the_permalink()?>">
<?php $thumb_img = has_post_thumbnail() ? get_the_post_thumbnail( $post->ID,array($width,$height),array('alt' => get_the_title()) ) : get_post_img($width,$height,$size); echo $thumb_img;?>
</a>
</div>
</div>
<?php }

//截取缩略图
if ( function_exists('add_theme_support') )
add_theme_support('post-thumbnails');
add_image_size('large',430,230,true);
add_image_size('medium',110,110,true);

//截取文字
if (!function_exists('utf8_str')){
	function utf8_str($str, $from, $len){
		return preg_replace('#^(?:[\x00-\x7F]|[\xC0-\xFF][\x80-\xBF]+){0,'.$from.'}'.
		'((?:[\x00-\x7F]|[\xC0-\xFF][\x80-\xBF]+){0,'.$len.'}).*#s',
		'$1',$str);
	}
}

//日志归档
class hacklog_archives{function GetPosts(){
global $wpdb;
if ( $posts = wp_cache_get( 'posts','ihacklog-clean-archives' ) )
return $posts;
$query="SELECT DISTINCT ID,post_date,post_date_gmt,comment_count,comment_status,post_password FROM $wpdb->posts WHERE post_type='post' AND post_status = 'publish' AND comment_status = 'open'";
$rawposts =$wpdb->get_results( $query,OBJECT );
foreach( $rawposts as $key => $post ){
$posts[ mysql2date( 'Y.m',$post->post_date ) ][] = $post;
$rawposts[$key] = null; 
}
$rawposts = null;
wp_cache_set( 'posts',$posts,'ihacklog-clean-archives' );;
return $posts;
}
function PostList( $atts = array() ){
global $wp_locale;
global $hacklog_clean_archives_config;
$atts = shortcode_atts(array(
'usejs' => $hacklog_clean_archives_config['usejs'],
'monthorder' => $hacklog_clean_archives_config['monthorder'],
'postorder' => $hacklog_clean_archives_config['postorder'],
'postcount' => '1',
'commentcount' => '1',),$atts);
$atts=array_merge(array('usejs'=>1,'monthorder' =>'new','postorder' =>'new'),$atts);
$posts = $this->GetPosts();('new' == $atts['monthorder'] ) ? krsort( $posts ) : ksort( $posts );
foreach( $posts as $key => $month ){
$sorter = array();
foreach ( $month as $post )
$sorter[] = $post->post_date_gmt;
$sortorder = ( 'new' == $atts['postorder'] ) ? SORT_DESC : SORT_ASC;
array_multisort( $sorter,$sortorder,$month );
$posts[$key] = $month;
unset($month);}
$html = '<div class="car-container';
if ( 1 == $atts['usejs'] ) $html .= ' car-collapse';
$html .= '">'. "\n";
if ( 1 == $atts['usejs'] ) $html .= '<a href="#" class="car-toggler">展开所有月份'."</a>\n\n";
$html .= '<ul class="car-list">' . "\n";
$firstmonth = TRUE;
foreach( $posts as $yearmonth => $posts ){
list( $year,$month ) = explode( '.',$yearmonth );
$firstpost = TRUE;
foreach( $posts as $post ){
if ( TRUE == $firstpost ){
$spchar = $firstmonth ? '<span class="car-toggle-icon car-minus">∧</span>' : '<span class="car-toggle-icon car-plus">∨</span>';
$html .= '<li><span class="car-yearmonth" style="cursor:pointer;">'.$spchar.' ' . sprintf( __('%1$s %2$d'),$wp_locale->get_month($month),$year );
if ( '0' != $atts['postcount'] ){$html .= ' <span>(共' . count($posts) . '篇文章)</span>';}
if ($firstmonth == FALSE){$html .= "</span>\n<ul class='car-monthlisting' style='display:none;'>\n";}
else{$html .= "</span>\n<ul class='car-monthlisting'>\n";}
$firstpost = FALSE;
$firstmonth = FALSE;
}
$html .= '<li>' . mysql2date( 'd',$post->post_date ) . '日<span>&hearts;</span><a rel="external" href="' . get_permalink( $post->ID ) . '">' . get_the_title( $post->ID ) . '</a>';
if ( '0' != $atts['commentcount'] && ( 0 != $post->comment_count || 'closed' != $post->comment_status ) && empty($post->post_password) )
$html .= '&nbsp;&nbsp;(' . $post->comment_count . '条评论)';
$html .= "</li>\n";
}
$html .= "</ul>\n</li>\n";
}
$html .= "</ul>\n</div>\n";
return $html;
}
function PostCount(){$num_posts = wp_count_posts( 'post' );return number_format_i18n( $num_posts->publish );
}
}
if(!empty($post->post_content)){
$all_config=explode(';',$post->post_content);
foreach($all_config as $item){
$temp=explode('=',$item);
$hacklog_clean_archives_config[trim($temp[0])]=htmlspecialchars(strip_tags(trim($temp[1])));
}
}
else{$hacklog_clean_archives_config=array('usejs'=>1,'monthorder' =>'new','postorder' =>'new');}
$hacklog_archives=new hacklog_archives();

//文章彩色标签
function getColorTags(){
	$colors=array('F99','C9C','F96','6CC','6C9','37A7FF','B0D686','E6CC6E');
	$posttags = get_the_tags();
	if ($posttags){
		$tagoutput = "";
		foreach($posttags as $tag){
			$tag_link = get_tag_link($tag->term_id);
			$color=$colors[dechex(rand(0,7))];
			$tagoutput .= '<a class="colortags bg" style="background-color:#'.$color.'" href="'.$tag_link.'" rel="tag">' . $tag->name . '</a>  ';
		}
		$tagoutput = substr($tagoutput,0,strlen($tagoutput)-2);
		echo $tagoutput;
	}
}

//自动生成版权时间
function comicpress_copyright(){
global $wpdb;$output;
$copyright_dates = $wpdb->get_results("SELECT YEAR(min(post_date_gmt)) AS firstdate, YEAR(max(post_date_gmt)) AS lastdate FROM $wpdb->posts WHERE post_status = 'publish'");
if($copyright_dates){
$copyright="&copy; ".$copyright_dates[0]->firstdate;
if($copyright_dates[0]->firstdate!=$copyright_dates[0]->lastdate){$copyright.='-'.$copyright_dates[0]->lastdate;}
$output = $copyright;
}
return $output;
}

//文章版权信息
function feed_copyright(){
	if(is_single() or is_feed()){
		$custom_fields = get_post_custom_keys($post_id，，FALSE);
		$Name= get_bloginfo('name');
		if (!in_array ('copyright',$custom_fields)){
			$content.= '<div class="post-info bd"><div>原创文章：<a href="'.get_bloginfo("url").'" rel="external" style="display:inline;">'.$Name.'</a>&nbsp;&nbsp;转载请注明！</div><div>文章标题：<a rel="bookmark external" href="'.get_permalink().'">'.get_the_title().'</a></div><div>永久链接：<a rel="bookmark external" href="'.get_permalink().'">'.get_permalink().'</a></div><div class="post-info-title">版权信息</div></div>';}
		else{
			$custom = get_post_custom($post_id，，FALSE);
			$custom_value = $custom['copyright'];
			$custom_url=$custom['copyrighturl'] ;
			$content.= '<div class="post-info bd"><div>文章来自：<a href="'.$custom_url[0].'" rel="external nofollow">'.$custom_value[0].'</a></div><div>文章标题：<a href="'.get_permalink().'" rel="external nofollow">'.get_the_title().'</a></div><div>永久链接：<a href="'.get_permalink().'" rel="external nofollow">'.get_permalink().'</a></div><div class="post-info-title">版权信息</div></div>';}
		}
	return $content;
}

//字数统计
function count_words ($text){
global $post;
if ( '' == $text ){
$text = $post->post_content;
if (mb_strlen($output, 'UTF-8') < mb_strlen($text, 'UTF-8')) $output .= mb_strlen(preg_replace('/\s/','',html_entity_decode(strip_tags($post->post_content))),'UTF-8');
return $output;
}
}

//分页
function pagination($query_string){
global $posts_per_page, $paged;
$my_query = new WP_Query($query_string ."&posts_per_page=-1");
$total_posts = $my_query->post_count;
if(empty($paged))$paged = 1;
$prev = $paged - 1;
$next = $paged + 1;
$range = 3; //分页数目
$showitems = ($range * 2)+1;
$pages = ceil($total_posts/$posts_per_page);
if(1 != $pages){
echo "<div class='pagination'>";
echo ($paged > 2 && $paged+$range+1 > $pages && $showitems < $pages)? "<a title='First Page' href='".get_pagenum_link(1)."' class='fir_las'>« «</a>":"";
echo ($paged > 1 && $showitems < $pages)? "<a title='Previous Page' href='".get_pagenum_link($prev)."' class='page_previous'>«</a>":"";
for ($i=1; $i <= $pages; $i++){
if (1 != $pages &&( !($i >= $paged+$range+1 || $i <= $paged-$range-1) || $pages <= $showitems )){
echo ($paged == $i)? "<span>".$i."</span>":"<a href='".get_pagenum_link($i)."'>".$i."</a>"; 
}
}
echo ($paged < $pages && $showitems < $pages) ? "<a title='Next Page' href='".get_pagenum_link($next)."' class='page_next'>»</a>" :"";
echo ($paged < $pages-1 && $paged+$range-1 < $pages && $showitems < $pages) ? "<a title='Last Page' href='".get_pagenum_link($pages)."' class='fir_las'>» »</a>":"";
echo "</div>\n";
}
}

//文章分页
function single_fenye(){
if(is_single() or is_feed()){
$args=array('before'=>'<div class="singleNav">','after'=>'</div>','next_or_number'=>'number','link_before'=>'<span class=" bd bg slow">','link_after'=>'</span>');
$fenye.=wp_link_pages($args);
}
return $fenye;
}

//fancybox 自动对图片链接添加属性
add_filter('the_content','fancybox');
function fancybox ($content){
global $post;
$pattern = "/<a(.*?)href=('|\")([^>]*).(bmp|gif|jpeg|jpg|png)('|\")(.*?)>(.*?)<\/a>/i";
$replacement = '<a$1href=$2$3.$4$5 rel="img" class="fancybox"$6>$7</a>';
$content = preg_replace($pattern,$replacement,$content);
return $content;
}

//图片添加alt属性
function image_alt( $imgalt ){
	global $post;
	$title = $post->post_title;
	$imgUrl = "<img\s[^>]*src=(\"??)([^\" >]*?)\\1[^>]*>";
	if(preg_match_all("/$imgUrl/siU",$imgalt,$matches,PREG_SET_ORDER)){
		if( !empty($matches) ){
			for ($i=0; $i < count($matches); $i++){
				$tag = $url = $matches[$i][0];
				$judge = '/alt=/';
				preg_match($judge,$tag,$match,PREG_OFFSET_CAPTURE);
				if( count($match) < 1 )
				$altURL = ' alt="'.$title.'"';
				$url = rtrim($url,'/>');
				$url .= $altURL.'/>';
				$imgalt = str_replace($tag,$url,$imgalt);
			}
		}
	}
	return $imgalt;
}
add_filter( 'the_content','image_alt');
add_filter( 'comment_text','image_alt');

//站外链接添加nofollow和新窗口打开
function url_parse_nofollow( $content ){
	$regexp = "<a\s[^>]*href=(\"??)([^\" >]*?)\\1[^>]*>";
	if(preg_match_all("/$regexp/siU",$content,$matches,PREG_SET_ORDER)){
		if( !empty($matches) ){
			$srcUrl = get_option('siteurl');
			for ($i=0; $i < count($matches); $i++)
			{
				$tag = $matches[$i][0];
				$tag2 = $matches[$i][0];
				$url = $matches[$i][0];
				$noFollow = '';
				$pattern = '/rel\s*=\s*"\s*[n|d]ofollow\s*"/';
				preg_match($pattern,$tag2,$match,PREG_OFFSET_CAPTURE);
				if( count($match) < 1 )
					$noFollow .= ' rel="external nofollow" ';
				$pos = stripos($url,$srcUrl);
				if ($pos === false){
					$tag = rtrim ($tag,'>');
					$tag .= $noFollow.'>';
					$content = str_replace($tag2,$tag,$content);
				}
			}
		}
	}
	$content = str_replace(']]>',']]>',$content);
	return $content;
}
add_filter( 'the_content','url_parse_nofollow');

function escapeCE($arr){
        if (version_compare(PHP_VERSION, '5.2.3') >= 0){ //所需PHP版本
                $output = htmlspecialchars($arr[2], ENT_NOQUOTES, get_bloginfo('charset'), false);
        } else {
                $needTo = array( '&' => '&amp;', '<' => '&lt;', '>' => '&gt;' );
                $data = htmlspecialchars_decode($arr[2]);
                $output = strtr($data, $needTo);
        }
        if (! empty($output)){ return  $arr[1] . $output . $arr[3];
        } else { return  $arr[1] . $arr[2] . $arr[3]; }
}
function replaceCE($data){
        $replaceTag = preg_replace_callback('@(<pre.*>)(.*)(</pre>)@isU', 'escapeCE', $data);
        $replaceTag = preg_replace_callback('@(<code.*>)(.*)(</code>)@isU', 'escapeCE', $replaceTag);
        return $replaceTag;
}
add_filter( 'the_content', 'replaceCE');

//评论回复/头像缓存
function metro_comment($comment,$args,$depth){
	$GLOBALS['comment'] = $comment;
global $commentcount,$wpdb,$post;
	if(!$commentcount){
		$comments = $wpdb->get_results("SELECT * FROM $wpdb->comments WHERE comment_post_ID = $post->ID AND comment_type = '' AND comment_approved = '1' AND !comment_parent");
		$cnt = count($comments);
		$page = get_query_var('cpage');
		$cpp=get_option('comments_per_page');
		if (ceil($cnt / $cpp) == 1 || ($page > 1 && $page == ceil($cnt / $cpp))){
			$commentcount = $cnt + 1;
		} else{
			$commentcount = $cpp * $page + 1;
		}
	}
?>
<li <?php comment_class(); ?>>
	<div id="comment-<?php comment_ID() ?>" class="comment-body">
	<?php $add_below = 'div-comment'; ?>
		<div class="comment-author vcard"><?php if (get_option('ini_type') == 'Display'){ if (get_option('ini_avatar') == 'true'){ ?>
			<?php
				$p = 'avatar/';
				$f = md5(strtolower($comment->comment_author_email));
				$a = $p . $f .'.jpg';
				$e = ABSPATH . $a;
				if (!is_file($e)){
				$d = get_bloginfo('wpurl'). '/avatar/avatar.jpg';
				$s = '40';
				$r = get_option('avatar_rating');
				$g = 'http://www.gravatar.com/avatar/'.$f.'.jpg?s='.$s.'&d='.$d.'&r='.$r;
				$avatarContent = file_get_contents($g);
				file_put_contents($e,$avatarContent);
				if ( filesize($e) == 0 ){ copy($d,$e); }
				};
			?>
			<div class="imgBack bd"><img src='<?php bloginfo('wpurl'); ?>/<?php echo $a ?>'/ class='avatar' alt='<?php echo $comment->comment_author;?>'></div>
			<?php } else { ?> <div class="imgBack bd"><?php echo get_avatar($comment,40,'',get_comment_author()); ?></div> <?php } } ?>
					<div class="floor"><?php
 if(!$parent_id = $comment->comment_parent){
	switch ($commentcount){
	case 2 :echo "Bugatti";--$commentcount;break;
	case 3 :echo "Lamborghini";--$commentcount;break;
	case 4 :echo "Ferrari";--$commentcount;break;
	case 5 :echo "Porsche";--$commentcount;break;
	default:printf('%1$s Floor',--$commentcount);
	}
 }
 ?>
		</div><strong><?php comment_author_link(); ?></strong><?php if($comment -> comment_parent) echo ' <strong>@<a href="#comment-'.$comment -> comment_parent.'">'.get_comment($comment -> comment_parent) -> comment_author.'</a></strong>'; ?>:<?php edit_comment_link('编辑','&nbsp;&nbsp;',''); ?></div>
		<?php if ( $comment->comment_approved == '0' ) : ?>
			<span style="color:#C00; font-style:inherit">您的评论正在等待审核中...</span>
			<br />			
		<?php endif; ?>
		<?php comment_text() ?>
		<div class="clear"></div><span class="datetime actions"><?php comment_date('Y-m-d') ?> <?php comment_time() ?>　</span> <span class="reply actions"><?php comment_reply_link(array_merge( $args,array('reply_text' => '回复　','add_below' =>$add_below,'depth' => $depth,'max_depth' => $args['max_depth']))); ?></span>
<span class="reply actions"><?php	
if ( is_user_logged_in() ){	
$url = get_bloginfo('url');	
echo '<a id="delete-'. $comment->comment_ID .'" href="' . wp_nonce_url("$url/wp-admin/comment.php?action=deletecomment&p=" . $comment->comment_post_ID . '&c=' . $comment->comment_ID,'delete-comment_' . $comment->comment_ID) . '"" >删除　</a>';	
}	
?></span> 
</div>
<?php
}
function metro_end_comment(){
		echo '</li>';
}

//密码保护提示
function password_hint( $c ){
global $post,$user_ID,$user_identity;
if ( empty($post->post_password) )
return $c;
if ( isset($_COOKIE['wp-postpass_'.COOKIEHASH]) && stripslashes($_COOKIE['wp-postpass_'.COOKIEHASH]) == $post->post_password )
return $c;
if($hint = get_post_meta($post->ID,'password_hint',true)){
$url = get_option('siteurl').'/wp-pass.php';
if($hint)
$hint = 'Password Hint : '.$hint;
else
$hint = "Please Enter Your Password !";
if($user_ID)
$hint .= sprintf('Welcome,Your password : ',$user_identity,$post->post_password);
$out = <<<END
<form method="post" action="$url">
<p>Password : </p>
<div>
<label>$hint<br/><input type="password" name="post_password"/></label>
<input type="submit" value="That's a secret !" name="Submit"/>
</div>
</form>
END;
return $out;
}else{
return $c;
}
}
add_filter('the_content','password_hint');

//屏蔽全英文评论
function refused_spam_comments( $comment_data ){
$pattern = '/[一-龥]/u';
if(!preg_match($pattern,$comment_data['comment_content'])){
err( "You should type some Chinese word (like \"你好\") in your comment to pass the spam-check, thanks for your patience!" );
}
return( $comment_data );
}
add_filter('preprocess_comment','refused_spam_comments');

//SMTP邮箱设置
if (get_option('ini_smtp_from')!==""){
function mail_smtp( $phpmailer ){
$phpmailer->From = stripslashes(get_option('ini_smtp_from'));
$phpmailer->FromName = stripslashes(get_option('ini_smtp_fromname'));
$phpmailer->Host = stripslashes(get_option('ini_smtp_host'));
$phpmailer->Port = stripslashes(get_option('ini_smtp_port'));
$phpmailer->SMTPSecure = stripslashes(get_option('ini_smtp_secure'));
$phpmailer->Username = stripslashes(get_option('ini_smtp_username'));
$phpmailer->Password = stripslashes(get_option('ini_smtp_password'));
$phpmailer->IsSMTP();
$phpmailer->SMTPAuth = true;
}
add_action('phpmailer_init','mail_smtp');
}

//去掉wp_head多余内容
function my_filter_head(){
remove_action('wp_head','_admin_bar_bump_cb');
remove_action( 'wp_head','feed_links_extra',3 );
remove_action( 'wp_head','feed_links',2 );
remove_action( 'wp_head','rsd_link' );
remove_action( 'wp_head','wlwmanifest_link' );
remove_action( 'wp_head','index_rel_link' );
remove_action( 'wp_head','parent_post_rel_link',10,0 );
remove_action( 'wp_head','start_post_rel_link',10,0 );
remove_action( 'wp_head','adjacent_posts_rel_link',10,0 );
remove_action( 'wp_head','wp_generator' );
}
add_action('get_header','my_filter_head');

//启用主题跳转
global $pagenow;
if ( is_admin() && isset( $_GET['activated'] ) && $pagenow == 'themes.php' ) {
	wp_redirect( admin_url( 'themes.php?page=guide' ) );
exit;
}
//全部设置结束
?>