<?php
if (get_option('ini_media')){
$media_music = 
    array(
        "name" => "music",
        "desc" => "发表音乐专用，输入示例音乐外链，仅在分类页面展示，方便网友试听。",
        "std" => "",
        "type" => "text",
        "title" => "音乐地址:");
$media_video = 
    array(
        "name" => "video",
        "desc" => "发表影视专用，输入示例视频/电影外链，仅在分类页面展示，方便网友观看。",
        "std" => "",
        "type" => "text",
        "title" => "视频地址:");
}
$new_meta_boxes = array(
    array(
        "name" => "description",
        "desc" => "输入文章的描述，一般不超过200个字符，留空则截取文章前200个字符或首个段落。",
        "std" => "",
        "type" => "textarea",
        "title" => "描述 (Description):"),
    array(
        "name" => "keywords",
        "desc" => "输入文章的关键词，半角逗号隔开，留空则使用标签作为关键词。",
        "std" => "",
        "type" => "textarea",
        "title" => "关键词 (KeyWords):"),
    $media_music, $media_video
);
function mytheme_add_init(){
wp_enqueue_style("functions",get_bloginfo('template_directory')."/includes/meta-box.css", false, "1.0", "all");
}
function new_meta_boxes(){
    ?><div id="media-box"><?php
    global $post, $new_meta_boxes;
    foreach($new_meta_boxes as $meta_box){
        $meta_box_value = get_post_meta($post->ID, $meta_box['name'].'_value', true);
        if($meta_box_value == "")
        $meta_box_value = $meta_box['std'];
            switch ( $meta_box['type'] ){
            case "text":
            ?>
            <strong><?php echo $meta_box['title']?></strong>
            <input name="<?php echo $meta_box['name'];echo '_value'; ?>" type="text" value="<?php echo $meta_box_value; ?>" /><br>
            <div class="desc"><?php echo $meta_box['desc'];echo'</div><br>'; break;
            case "textarea":
            ?>
            <strong><?php echo $meta_box['title']?></strong><br>
            <textarea name="<?php echo $meta_box['name'];echo '_value'; ?>" type="textarea" onclick="if(this.value == '<?php echo $meta_box['std']; ?>'){this.value = '';}" onblur="if(this.value == ''){this.value = '<?php echo $meta_box['std']; ?>';}"><?php echo $meta_box_value;?></textarea><br>
            <div class="desc"><?php echo $meta_box['desc'];echo'</div><br>'; break;
            }
    }
    echo '<input type="hidden" name="newmetaboxes" id="newmetaboxes" value="'.wp_create_nonce( plugin_basename(__FILE__) ).'" /></div>';
}

function create_meta_box(){
    global $theme_name;
    if ( function_exists('add_meta_box') ){
        add_meta_box( 'new-meta-boxes', '文章及媒体功能', 'new_meta_boxes', 'post', 'normal', 'high' );
    }
}

function save_postdata( $post_id ){
    global $new_meta_boxes;
    if ( !wp_verify_nonce( $_POST['newmetaboxes'], plugin_basename(__FILE__) ))
        return;
    if ( !current_user_can( 'edit_posts', $post_id ))
        return;
    foreach($new_meta_boxes as $meta_box){
        $data = $_POST[$meta_box['name'].'_value'];
        if(get_post_meta($post_id, $meta_box['name'].'_value') == "")
            add_post_meta($post_id, $meta_box['name'].'_value', $data, true);
        elseif($data != get_post_meta($post_id, $meta_box['name'].'_value', true))
            update_post_meta($post_id, $meta_box['name'].'_value', $data);
        elseif($data == "")
            delete_post_meta($post_id, $meta_box['name'].'_value', get_post_meta($post_id, $meta_box['name'].'_value', true));
    }
}
add_action('admin_menu', 'create_meta_box');
add_action('save_post', 'save_postdata');
add_action('admin_init', 'mytheme_add_init');
?>