<?php
//最近评论插件
class cy_comment extends WP_Widget {

    function cy_comment() {
        $widget_ops = array('description' => '显示粉丝们最新的评论');
        $this->WP_Widget('cy_comment', '草野插件：最新评论', $widget_ops);
    }

    function form($instance) {
        $title = isset($instance['title']) ? esc_attr($instance['title']) : '';
        $limit = isset($instance['limit']) ? absint($instance['limit']) : 8;
        $img_size = isset($instance['img_size']) ? absint($instance['img_size']) : 40;
?>
    <p><label for="<?php echo $this->get_field_id('title'); ?>"><?php esc_attr_e('标题：'); ?> <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></label></p>

    <p><label for="<?php echo $this->get_field_id('limit'); ?>"><?php _e('评论数量：'); ?></label>
        <input id="<?php echo $this->get_field_id('limit'); ?>" name="<?php echo $this->get_field_name('limit'); ?>" type="text" value="<?php echo $limit; ?>" size="3" /></p>

    <p><label for="<?php echo $this->get_field_id('img_size'); ?>"><?php _e('头像大小：'); ?></label>
        <input id="<?php echo $this->get_field_id('img_size'); ?>" name="<?php echo $this->get_field_name('img_size'); ?>" type="text" value="<?php echo $img_size; ?>" size="3" /></p>
<?php
    }

    function update($new_instance, $old_instance) {
        return $new_instance;
    }

    function widget($args, $instance) {
        extract( $args );
        $title = apply_filters('widget_title', empty($instance['title']) ? __('最新评论', 'cy_comment') : $instance['title']);
        $limit = absint($instance['limit']);
        $img_size =  absint($instance['img_size']);
        echo $before_widget.$before_title.$title.$after_title;
        echo cy_widget_comment($img_size,$limit);
        echo $after_widget;
    }
}
register_widget('cy_comment');

function cy_widget_comment($img_size,$limit){
?>
<ul class="cy_comment">
<?php 
global $wpdb;
$sql = "SELECT DISTINCT ID, post_title, post_password, comment_ID, comment_post_ID, comment_author, comment_date_gmt, comment_approved,comment_author_email, comment_type,comment_author_url, 
	SUBSTRING(comment_content,1,48) AS com_excerpt
	FROM $wpdb->comments LEFT OUTER JOIN $wpdb->posts ON ($wpdb->comments.comment_post_ID = $wpdb->posts.ID) WHERE comment_approved = '1' AND comment_type = '' AND post_password = '' ORDER BY comment_date_gmt DESC LIMIT $limit ";
$comments = $wpdb->get_results($sql);
foreach ($comments as $comment) {
if($comment->comment_author == ""){$comment->comment_author="Anonymous";}
$a= get_bloginfo('wpurl').'/avatar/'.md5(strtolower($comment->comment_author_email)).'.jpg';
if (get_option('ini_avatar')) {
$output .= "\n<li><img src='".$a."' alt=\"$comment->comment_author\" class='avatar' width='$img_size' height='$img_size'/><strong>".strip_tags($comment->comment_author)."：</strong><br /><a href=\"" .get_permalink($comment->ID) ."#comment-" .$comment->comment_ID. "\" title=\"".strip_tags($comment->comment_author)."发表在: " .$comment->post_title. "\">" .do_shortcode(strip_tags($comment->com_excerpt))."</a></li>";}
else {
$output .= "<li>".get_avatar( $comment->comment_author_email,$img_size,get_bloginfo('template_directory') . '/images/avatar.jpg',$comment->comment_author)."<strong>". strip_tags($comment->comment_author) ."：</strong><br /><a href=\"" . get_permalink($comment->ID) ."#comment-" .$comment->comment_ID. "\" title=\"".strip_tags($comment->comment_author)."发表在: " .$comment->post_title. "\">" .do_shortcode(strip_tags($comment->com_excerpt))."</a></li>";}
}
$output .= $post_HTML;
$output = convert_smilies($output);
echo $output;
?>
</ul>
<?php }?>