<?php
//近期读者小工具
class cy_readers extends WP_Widget {

    function cy_readers() {
        $widget_ops = array('description' => '显示近期回复最多的读者');
        $this->WP_Widget('cy_readers', '草野插件：活跃读者', $widget_ops);
    }

    function form($instance) {
        $title = isset($instance['title']) ? esc_attr($instance['title']) : '';
        $limit = isset($instance['limit']) ? absint($instance['limit']) : 10;
        $time = isset($instance['time']) ? absint($instance['time']) : 30;
        $img_size = isset($instance['img_size']) ? absint($instance['img_size']) : 40;
?>
    <p><label for="<?php echo $this->get_field_id('title'); ?>"><?php esc_attr_e('标题：'); ?> <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></label></p>

    <p><label for="<?php echo $this->get_field_id('limit'); ?>"><?php _e('访客数量：'); ?></label>
        <input id="<?php echo $this->get_field_id('limit'); ?>" name="<?php echo $this->get_field_name('limit'); ?>" type="text" value="<?php echo $limit; ?>" size="3" /></p>

    <p><label for="<?php echo $this->get_field_id('time'); ?>"><?php _e('统计天数：'); ?></label>
        <input id="<?php echo $this->get_field_id('time'); ?>" name="<?php echo $this->get_field_name('time'); ?>" type="text" value="<?php echo $time; ?>" size="3" /></p>

    <p><label for="<?php echo $this->get_field_id('img_size'); ?>"><?php _e('头像大小：'); ?></label>
        <input id="<?php echo $this->get_field_id('img_size'); ?>" name="<?php echo $this->get_field_name('img_size'); ?>" type="text" value="<?php echo $img_size; ?>" size="3" /></p>
<?php
    }

    function update($new_instance, $old_instance) {
        return $new_instance;
    }

    function widget($args, $instance) {
        extract( $args );
        $title = apply_filters('widget_title', empty($instance['title']) ? __('本站贵宾', 'cy_readers') : $instance['title']);
        $limit = absint($instance['limit']);
        $time = absint($instance['time']);
        $img_size = absint($instance['img_size']);
        echo $before_widget.$before_title.$title.$after_title;
        echo cy_widget_readers($img_size,$time,$limit);
        echo $after_widget;
    }
}
register_widget('cy_readers');

function cy_widget_readers($img_size,$time,$limit){
?>
<ul class="cy_readers">
<?php
global $wpdb;
$sql="SELECT COUNT(comment_ID) AS cnt, comment_author, comment_author_url, comment_author_email FROM (SELECT * FROM $wpdb->comments LEFT OUTER JOIN $wpdb->posts ON ($wpdb->posts.ID=$wpdb->comments.comment_post_ID) WHERE comment_date > date_sub( NOW(), INTERVAL $time day ) AND user_id='0' AND comment_author_email != '' AND post_password='' AND comment_approved='1' AND comment_type='') AS tempcmt GROUP BY comment_author_email ORDER BY cnt DESC LIMIT $limit";
$wall = $wpdb->get_results($sql);
foreach ($wall as $comment) {
if($comment->comment_author == ""){$comment->comment_author="Anonymous";}
$a= get_bloginfo('wpurl').'/avatar/'.md5(strtolower($comment->comment_author_email)).'.jpg';
if( $comment->comment_author_url )
$url = 'href="'.$comment->comment_author_url.'" rel="external nofollow"';
else $url='href="#" rel="external"';
if (get_option('ini_avatar')) {
$tmp .= "<li><a $url title='".$comment->comment_author." 留下".$comment->cnt."条信息'><img src='".$a."' alt=\"$comment->comment_author\" class='avatar' width='$img_size' height='$img_size'/></a></li>";}
else {
$tmp .= "<li><a $url title='".$comment->comment_author." 留下".$comment->cnt."条信息'>".get_avatar($comment->comment_author_email,$img_size,get_bloginfo('template_directory'). '/images/avatar.jpg',$comment->comment_author)."</a></li>";}
}
echo $tmp;
?>
</ul>
<?php }?>