<?php 
//侧边栏统计插件
class cy_statistics extends WP_Widget {

    function cy_statistics() {
        $widget_ops = array('description' => '统计站点的日志、评论、标签等数据');
        $this->WP_Widget('cy_statistics', '草野插件：站点统计', $widget_ops);
    }

    function form($instance) {
        $title = isset($instance['title']) ? esc_attr($instance['title']) : '';
        $year = isset($instance['year']) ? absint($instance['year']) : 2013;
        $mouth = isset($instance['mouth']) ? absint($instance['mouth']) : 8;
        $day = isset($instance['day']) ? absint($instance['day']) : 9;
        ?>
        <p><label for="<?php echo $this->get_field_id('title'); ?>"><?php esc_attr_e('标题：'); ?><input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></label></p>
        <p><label for="<?php echo $this->get_field_id('year'); ?>"><?php _e('建站日期：'); ?></label><input id="<?php echo $this->get_field_id('year'); ?>" name="<?php echo $this->get_field_name('year'); ?>" type="text" value="<?php echo $year ?>" size="3" />年 <label for="<?php echo $this->get_field_id('mouth'); ?>"></label><input id="<?php echo $this->get_field_id('mouth'); ?>" name="<?php echo $this->get_field_name('mouth'); ?>" type="text" value="<?php echo $mouth ?>" size="3" />月 <label for="<?php echo $this->get_field_id('day'); ?>"></label><input id="<?php echo $this->get_field_id('day'); ?>" name="<?php echo $this->get_field_name('day'); ?>" type="text" value="<?php echo $day ?>" size="3" />日</p>
        <?php 
    }

    function update($new_instance, $old_instance) {
        return $new_instance;
    }

    function widget($args, $instance) {
        extract( $args );
        $title = apply_filters('widget_title', empty($instance['title']) ? __('站点统计', 'cy_tags') : $instance['title']);
        $year = absint($instance['year']);
        $mouth = absint($instance['mouth']);
        $day = absint($instance['day']);
        echo $before_widget.$before_title.$title.$after_title;
        echo cy_widget_statistics($year,$mouth,$day);
        echo $after_widget;
    }
}
register_widget('cy_statistics');

function cy_widget_statistics($year,$mouth,$day){
global $wpdb;
$time = $year.-$mouth.-$day
?>
<ul>
<li>日志总数：<?php $count_posts = wp_count_posts(); echo $published_posts = $count_posts->publish;?> 篇</li>
<li>评论总数：<?php echo $wpdb->get_var("SELECT COUNT(*) FROM $wpdb->comments where comment_author!='".(get_option('user'))."'");?> 篇</li>
<li>标签数量：<?php echo $count_tags = wp_count_terms('post_tag'); ?> 个</li>
<li>链接总数：<?php $link = $wpdb->get_var("SELECT COUNT(*) FROM $wpdb->links WHERE link_visible = 'Y'"); echo $link; ?> 个</li>
<li>建站日期：<?php echo $time ?></li>
<li>运行天数：<?php echo floor((time()-strtotime($time))/86400); ?> 天</li>
<li>最后更新：<?php $last = $wpdb->get_results("SELECT MAX(post_modified) AS MAX_m FROM $wpdb->posts WHERE (post_type = 'post' OR post_type = 'page') AND (post_status = 'publish' OR post_status = 'private')");$last = date('Y-n-j', strtotime($last[0]->MAX_m));echo $last; ?></li>
</ul>
<?php
}
?>