<?php 
//标签云插件
class cy_tags extends WP_Widget {

    function cy_tags() {
        $widget_ops = array('description' => '随机显示标签，可自定义数量，大小');
        $this->WP_Widget('cy_tags', '草野插件：标签云', $widget_ops);
    }

    function form($instance) {
        $title = isset($instance['title']) ? esc_attr($instance['title']) : '';
        $counts = isset($instance['counts']) ? absint($instance['counts']) : 32;
        $min_size = isset($instance['min_size']) ? absint($instance['min_size']) : 12;
        $max_size = isset($instance['max_size']) ? absint($instance['max_size']) : 20;
?>
    <p><label for="<?php echo $this->get_field_id('title'); ?>"><?php esc_attr_e('标题：'); ?> <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></label></p>

    <p><label for="<?php echo $this->get_field_id('counts'); ?>"><?php _e('标签数量：'); ?></label>
        <input id="<?php echo $this->get_field_id('counts'); ?>" name="<?php echo $this->get_field_name('counts'); ?>" type="text" value="<?php echo $counts; ?>" size="3" /></p>

    <p><label for="<?php echo $this->get_field_id('min_size'); ?>"><?php _e('最小字号：'); ?></label>
        <input id="<?php echo $this->get_field_id('min_size'); ?>" name="<?php echo $this->get_field_name('min_size'); ?>" type="text" value="<?php echo $min_size; ?>" size="3" /></p>

    <p><label for="<?php echo $this->get_field_id('max_size'); ?>"><?php _e('最大字号：'); ?></label>
        <input id="<?php echo $this->get_field_id('max_size'); ?>" name="<?php echo $this->get_field_name('max_size'); ?>" type="text" value="<?php echo $max_size; ?>" size="3" /></p>
<?php
    }

    function update($new_instance, $old_instance) {
        return $new_instance;
    }

    function widget($args, $instance) {
        extract( $args );
        $title = apply_filters('widget_title', empty($instance['title']) ? __('标签云集', 'cy_tags') : $instance['title']);
        $counts =  absint($instance['counts']);
        $min_size =  absint($instance['min_size']);
        $max_size = absint($instance['max_size']);
        echo $before_widget.$before_title.$title.$after_title;?>
        <div class="tags">
        <?php wp_tag_cloud('smallest='.$min_size.'&largest='.$max_size.'&unit=px&number='.$counts.'&orderby=count&order=RAND');?>
        </div>
        <?php echo $after_widget;
    }
}
register_widget('cy_tags');
?>