<?php
	if (!empty($_SERVER['SCRIPT_FILENAME']) && 'comments.php' == basename($_SERVER['SCRIPT_FILENAME']))
		die (__("Please do not load this page directly. Thanks!", 'ifonder'));

	if ( post_password_required() ) { ?>
		<p class="nocomments"><?php _e("This post is password protected. Enter the password to view comments.", 'ifonder'); ?></p>
	<?php
		return;
	}
?>

<?php if ( have_comments() ) : ?>
<div id="comments">
    <div class="comment_post_title">
	<p><?php _e("Comments", 'ifonder'); ?> &middot; <?php comments_number(__("No Responses", 'ifonder'), __("One Response", 'ifonder'), __("% Responses", 'ifonder'));?></p>
	</div>
	<ol class="commentlist"><?php wp_list_comments(array('callback' => 'ht_custom_comment')); ?></ol>
	<?php 
	if (get_option('page_comments')) {
		$comment_pages = paginate_comments_links('echo=0');
			if ($comment_pages) {
			echo '<div  class="pagenavi">';
			echo $comment_pages;
			echo '</div>';
		}
	}?>
</div>
	
 <?php else :  ?>
	<?php if ('open' == $post->comment_status) : ?>
	 <?php else :  ?>
		<p class="nocomments"><?php _e("Comments are closed.", 'ifonder'); ?></p>
	<?php endif; ?>
<?php endif; ?>


<?php if ('open' == $post->comment_status) : ?>

<div id="respond">

<h4><?php _e("Leave A Comment", 'ifonder'); ?></h4>

<div class="cancel-comment-reply">
	<small><?php cancel_comment_reply_link(); ?></small>
</div>

<?php if ( get_option('comment_registration') && !$user_ID ) : ?>
<p><?php _e("You must be", 'ifonder'); ?> <a href="<?php echo get_option('siteurl'); ?>/wp-login.php?redirect_to=<?php echo urlencode(get_permalink()); ?>"><?php _e("logged in", 'ifonder'); ?></a> <?php _e("to post a comment.", 'ifonder'); ?></p></div>
<?php else : ?>

<form action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post" id="commentform">

<?php if ( $user_ID ) : ?>

<p><?php _e("Logged in as", 'ifonder'); ?> <a href="<?php echo get_option('siteurl'); ?>/wp-admin/profile.php"><?php echo $user_identity; ?></a>. <a href="<?php echo wp_logout_url(get_permalink()); ?>" title="Log out of this account"><?php _e("Log out", 'ifonder'); ?> &raquo;</a></p>

<?php else : ?>

<p><input type="text" name="author" id="author" value="<?php echo $comment_author; ?>" size="22" tabindex="1" <?php if ($req) echo "aria-required='true'"; ?> />
<label for="author"><?php _e("Name", 'ifonder'); ?> <?php if ($req) _e("(required)", 'ifonder'); ?></label></p>

<p><input type="text" name="email" id="email" value="<?php echo $comment_author_email; ?>" size="22" tabindex="2" <?php if ($req) echo "aria-required='true'"; ?> />
<label for="email"><?php _e("Mail (will not be published)", 'ifonder'); ?> <?php if ($req) _e("(required)", 'ifonder'); ?></label></p>

<p><input type="text" name="url" id="url" value="<?php echo $comment_author_url; ?>" size="22" tabindex="3" />
<label for="url"><?php _e("Website", 'ifonder'); ?></label></p>

<?php endif; ?>

<!--<p><small><strong>XHTML:</strong> You can use these tags: <code><?php echo allowed_tags(); ?></code></small></p>-->
<?php include(TEMPLATEPATH . '/smiley.php'); ?>
<p><textarea name="comment" id="comment" cols="100%" rows="10" tabindex="4"></textarea></p>

<p><input name="submit" type="submit" id="submit" tabindex="5" value="<?php _e("Submit Comment", 'ifonder'); ?>" />
<?php comment_id_fields(); ?>
</p>
<?php do_action('comment_form', $post->ID); ?>

</form>
</div>

<?php endif;  ?>
<?php endif;  ?>