<?php
function optionsframework_option_name() {
	$themename = get_theme_data(STYLESHEETPATH . '/style.css');
	$themename = $themename['Name'];
	$themename = preg_replace("/\W/", "", strtolower($themename) );

	$optionsframework_settings = get_option('optionsframework');
	$optionsframework_settings['id'] = $themename;
	update_option('optionsframework', $optionsframework_settings);
}

function optionsframework_options() {

	// Test data
	$test_array = array("one" => __("One", 'ifonder'),"two" => __("Two", 'ifonder'),"three" => __("Three", 'ifonder'),"four" => __("Four", 'ifonder'),"five" => __("Five", 'ifonder'));

	// Multicheck Array
	$multicheck_array = array("one" => __("French Toast", 'ifonder'), "two" => __("Pancake", 'ifonder'), "three" => __("Omelette", 'ifonder'), "four" => __("Crepe", 'ifonder'), "five" => __("Waffle", 'ifonder'));

	// Multicheck Defaults
	$multicheck_defaults = array("one" => "true","five" => "true");

	// Background Defaults
	$background_defaults = array('color' => '', 'image' => '', 'repeat' => 'repeat','position' => 'top center','attachment'=>'scroll');
	
	// Yes or No Array
	$yesno_array = array("true" => __("Yes", 'ifonder'), "false" => __("No", 'ifonder'));


	// Pull all the categories into an array
	$options_categories = array();  
	$options_categories_obj = get_categories();
	foreach ($options_categories_obj as $category) {
    	$options_categories[$category->cat_ID] = $category->cat_name;
	}
	
	// Add all categories option
    $options_categories[0] = __("All Categories", 'ifonder');

	// Pull all the pages into an array
	$options_pages = array();  
	$options_pages_obj = get_pages('sort_column=post_parent,menu_order');
	$options_pages['false'] = __("Select a page:", 'ifonder');
	foreach ($options_pages_obj as $page) {
    	$options_pages[$page->ID] = $page->post_title;
	}

	// If using image radio buttons, define a directory path
	$imagepath =  get_bloginfo('stylesheet_directory') . '/images/';

	$options = array();

	$options[] = array( "name" => __("Homepage Settings", 'ifonder'),
						"type" => "heading");
						
	$options[] = array( "name" => __("Homepage Posts Category", 'ifonder'),
						"desc" => __("Choose the category you wish to display in the homepage posts beneath the slider.", 'ifonder'),
						"id" => "category_homeblog",
						"std" => __("Select a category:", 'ifonder'),
						"type" => "select",
						"options" => $options_categories);
						
	$options[] = array( "name" => __("Number Of Homepage Posts Displayed", 'ifonder'),
						"desc" => __("Enter the number of posts you would like to display on the homepage.", 'ifonder'),
						"id" => "postnumber_homeblog",
						"std" => "4",
						"type" => "text");
						
	$options[] = array( "name" => __("Page Template", 'ifonder'),
						"type" => "heading");
						
	$options[] = array( "name" => __("Blog Template Category", 'ifonder'),
						"desc" => __("Choose the category you wish to display on the blog page template.", 'ifonder'),
						"id" => "select_categories_blog",
						"std" => __("Select a category:", 'ifonder'),
						"type" => "select",
						"options" => $options_categories);
								
	$options[] = array( "name" => __("Blog Posts To Display", 'ifonder'),
						"desc" => __("Enter the number of posts you would like to display on the blog page template.", 'ifonder'),
						"id" => "number_display_blog",
						"std" => "5",
						"type" => "text");
						
	$options[] = array( "name" => __("Blog_2 Template Category", 'ifonder'),
						"desc" => __("Choose the category you wish to display on the blog page template.", 'ifonder'),
						"id" => "select_categories_blog2",
						"std" => __("Select a category:", 'ifonder'),
						"type" => "select",
						"options" => $options_categories);
								
	$options[] = array( "name" => __("Blog_2 Posts To Display", 'ifonder'),
						"desc" => __("Enter the number of posts you would like to display on the blog page template.", 'ifonder'),
						"id" => "number_display_blog2",
						"std" => "5",
						"type" => "text");
						
	$options[] = array( "name" => __("2 Column Portfolio Template Category", 'ifonder'),
						"desc" => __("Choose the category you wish to display on the 2 column portfolio page template.", 'ifonder'),
						"id" => "select_categories_portfolio_2",
						"std" => __("Select a category:", 'ifonder'),
						"type" => "select",
						"options" => $options_categories);
								
	$options[] = array( "name" => __("2 Column Portfolio Posts To Display", 'ifonder'),
						"desc" => __("Enter the number of posts you would like to display on the 2 column portfolio page template.", 'ifonder'),
						"id" => "number_display_portfolio_2",
						"std" => "12",
						"type" => "text");
						
	$options[] = array( "name" => __("3 Column Portfolio Template Category", 'ifonder'),
						"desc" => __("Choose the category you wish to display on the 3 column portfolio page template.", 'ifonder'),
						"id" => "select_categories_portfolio_3",
						"std" => __("Select a category:", 'ifonder'),
						"type" => "select",
						"options" => $options_categories);
								
	$options[] = array( "name" => __("3 Column Portfolio Posts To Display", 'ifonder'),
						"desc" => __("Enter the number of posts you would like to display on the 3 column portfolio page template.", 'ifonder'),
						"id" => "number_display_portfolio_3",
						"std" => "12",
						"type" => "text");
						
	$options[] = array( "name" => __("Colors", 'ifonder'),
						"type" => "heading");
						
	$options[] = array( "name" => __("Menu Hover Color", 'ifonder'),
						"desc" => __("Select the color you wish to use for the menu hover colors.", 'ifonder'),
						"id" => "menu_color",
						"std" => "#333333",
						"type" => "color");
						
	$options[] = array( "name" => __("Link Color", 'ifonder'),
						"desc" => __("Select the color you wish to use for the link colors.", 'ifonder'),
						"id" => "link_color",
						"std" => "#3399FF",
						"type" => "color");
						
	$options[] = array( "name" => __("Link Hover Color", 'ifonder'),
						"desc" => __("Select the color you wish to use for the link hover colors.", 'ifonder'),
						"id" => "link_hover_color",
						"std" => "#3399FF",
						"type" => "color");
						
	$options[] = array( "name" => __("Highlight Color", 'ifonder'),
						"desc" => __("Select the color you wish to use for the highlight color. This refers to colors throughout the theme that are not links.", 'ifonder'),
						"id" => "highlight_color",
						"std" => "#3399FF",
						"type" => "color");	

	return $options;
}