<?php
/*
Template Name: Archive Page
*/
?>

<?php get_header(); ?>

<div id="container">

	<div id="content" class="homeleft">

        <div class="postarea">
		

				<div class="archive_column_left">
					
					<div class="related_post_title"><?php _e("By Category:", 'ifonder'); ?></div>

						<ul>
							<?php wp_list_categories('sort_column=name&title_li='); ?>
						</ul>
					
				</div>		

				<div class="archive_column_right">

					<div class="related_post_title"><?php _e("By Page:", 'ifonder'); ?></div>

						<ul>
							<?php wp_list_pages('title_li='); ?>
						</ul>	

				</div>
				
				<div class="archive_column_bottom">	
				
				<?php get_header(); query_posts('posts_per_page=-1');
				$dates_array 			= Array();
				$year_array 			= Array();
				$i 						= 0;
				$prev_post_ts    		= null;
				$prev_post_year  		= null;
				$distance_multiplier 	 = 2;
				?>

				<?php while (have_posts()) : the_post();

				$post_ts    =  strtotime($post->post_date);
				$post_year  =  date( 'Y', $post_ts );
				if ( is_null( $prev_post_year ) ) {
				?>
				<div class="related_post_title"><?=$post_year?> <?php _e("Timelined Archives", 'ifonder'); ?></div>
				<ol class="archives_list">
					<?php
						}
						else if ( $prev_post_year != $post_year ) {
					?>
				</ol>
				<?php
				$working_year  =  $prev_post_year;
				while ( $working_year > $post_year ) {
				$working_year--;
				?>
				<div class="related_post_title"><?=$working_year?> <?php _e("Timelined Archives", 'ifonder'); ?></div>
				<?php
				}
				?>
				<ol class="archives_list">
				<?php
				}
				if ( ! is_null( $prev_post_ts ) && $prev_post_year == $post_year ) {
					$dates_diff  =  ( date( 'z', $prev_post_ts ) - date( 'z', $post_ts ) ) * $distance_multiplier;
				}
				else {
				$dates_diff  =  0;
				}
				?>
				<li style="margin-top:<?=$dates_diff?>px"><span class="date"><?php the_time('F j'); ?></span> <a href="<?php the_permalink() ?>"><?php the_title(); ?></a><span class="view"> &middot; <?php if(function_exists('the_views')) { the_views(); } ?></span></li>
				<?php
				$prev_post_ts    =  $post_ts;
				$prev_post_year  =  $post_year;
				endwhile;
				if ( ! is_null( $prev_post_ts ) ) {
				?>
				</ol>
				<?php } ?>
				
				</div>
				
				<?php if (function_exists('get_least_viewed')): //base on plugin wp-postview, Attention plz! ?>
				<div class="related_post_title" style="text-transform:capitalize">Least Viewed Posts &raquo; Top 10</div>
				<ul class="related_post"> <?php // base on the plugin wordpress related posts, Attention plz! ?>
				<?php get_least_viewed('post', 10); ?>
				</ul>
				<?php endif; ?>
          </div>

	</div>

<?php include(TEMPLATEPATH."/sidebar.php");?>

</div>

<?php get_footer(); ?>