<?php



/*-----------------------------------------------------------------------------------*/

/*	Button Config

/*-----------------------------------------------------------------------------------*/



$zilla_shortcodes['button'] = array(

	'no_preview' => true,

	'params' => array(

		'url' => array(

			'std' => '',

			'type' => 'text',

			'label' => __('Button URL', 'textdomain'),

			'desc' => __('Add the button\'s url eg http://example.com', 'textdomain')

		),

		'style' => array(

			'type' => 'select',

			'label' => __('Button Style', 'textdomain'),

			'desc' => __('Select the button\'s style, ie the button\'s colour', 'textdomain'),

			'options' => array(

				'grey' => 'Grey',

				'black' => 'Black',

				'green' => 'Green',

				'light-blue' => 'Light Blue',

				'blue' => 'Blue',

				'red' => 'Red',

				'orange' => 'Orange',

				'purple' => 'Purple'

			)

		),

		'size' => array(

			'type' => 'select',

			'label' => __('Button Size', 'textdomain'),

			'desc' => __('Select the button\'s size', 'textdomain'),

			'options' => array(

				'small' => 'Small',

				'medium' => 'Medium',

				'large' => 'Large'

			)

		),

		'type' => array(

			'type' => 'select',

			'label' => __('Button Type', 'textdomain'),

			'desc' => __('Select the button\'s type', 'textdomain'),

			'options' => array(

				'round' => 'Round',

				'square' => 'Square'

			)

		),

		'target' => array(

			'type' => 'select',

			'label' => __('Button Target', 'textdomain'),

			'desc' => __('_self = open in same window. _blank = open in new window', 'textdomain'),

			'options' => array(

				'_self' => '_self',

				'_blank' => '_blank'

			)

		),

		'content' => array(

			'std' => 'Button Text',

			'type' => 'text',

			'label' => __('Button\'s Text', 'textdomain'),

			'desc' => __('Add the button\'s text', 'textdomain'),

		)

	),

	'shortcode' => '[magz_button url="{{url}}" style="{{style}}" size="{{size}}" type="{{type}}" target="{{target}}"] {{content}} [/magz_button]',

	'popup_title' => __('Insert Button Shortcode', 'textdomain')

);



/*-----------------------------------------------------------------------------------*/

/*	Alert Config

/*-----------------------------------------------------------------------------------*/



$zilla_shortcodes['alert'] = array(

	'no_preview' => true,

	'params' => array(

		'style' => array(

			'type' => 'select',

			'label' => __('Alert Style', 'textdomain'),

			'desc' => __('Select the alert\'s style, ie the alert colour', 'textdomain'),

			'options' => array(

				'white' => 'White',

				'grey' => 'Grey',

				'red' => 'Red',

				'blue' => 'Blue',

				'yellow' => 'Yellow',

				'green' => 'Green'

			)

		),

		'content' => array(

			'std' => 'Your Alert!',

			'type' => 'textarea',

			'label' => __('Alert Text', 'textdomain'),

			'desc' => __('Add the alert\'s text', 'textdomain'),

		)

		

	),

	'shortcode' => '[magz_alert style="{{style}}"] {{content}} [/magz_alert]',

	'popup_title' => __('Insert Alert Shortcode', 'textdomain')

);





/*-----------------------------------------------------------------------------------*/

/*	Title Config

/*-----------------------------------------------------------------------------------*/



$zilla_shortcodes['title'] = array(

	'no_preview' => true,

	'params' => array(

		'style' => array(

			'type' => 'select',

			'label' => __('Title Style', 'textdomain'),

			'desc' => __('Select the title\'s style, ie the alert colour', 'textdomain'),

			'options' => array(

				'white' => 'White',

				'grey' => 'Grey',

				'red' => 'Red',

				'blue' => 'Blue',

				'yellow' => 'Yellow',

				'green' => 'Green'

			)

		),

		'content' => array(

			'std' => 'Your Title!',

			'type' => 'textarea',

			'label' => __('Title Text', 'textdomain'),

			'desc' => __('Add the title\'s text', 'textdomain'),

		)

		

	),

	'shortcode' => '[magz_title style="{{style}}"] {{content}} [/magz_title]',

	'popup_title' => __('Insert Title Shortcode', 'textdomain')

);





/*-----------------------------------------------------------------------------------*/

/*	Toggle Config

/*-----------------------------------------------------------------------------------*/



$zilla_shortcodes['toggle'] = array(

	'no_preview' => true,

	'params' => array(

		'title' => array(

			'type' => 'text',

			'label' => __('Toggle Content Title', 'textdomain'),

			'desc' => __('Add the title that will go above the toggle content', 'textdomain'),

			'std' => 'Title'

		),

		'content' => array(

			'std' => 'Content',

			'type' => 'textarea',

			'label' => __('Toggle Content', 'textdomain'),

			'desc' => __('Add the toggle content. Will accept HTML', 'textdomain'),

		),

		'state' => array(

			'type' => 'select',

			'label' => __('Toggle State', 'textdomain'),

			'desc' => __('Select the state of the toggle on page load', 'textdomain'),

			'options' => array(

				'open' => 'Open',

				'closed' => 'Closed'

			)

		),

		

	),

	'shortcode' => '[magz_toggle title="{{title}}" state="{{state}}"] {{content}} [/magz_toggle]',

	'popup_title' => __('Insert Toggle Content Shortcode', 'textdomain')

);



/*-----------------------------------------------------------------------------------*/

/*	Tabs Config

/*-----------------------------------------------------------------------------------*/



$zilla_shortcodes['tabs'] = array(

    'params' => array(),

    'no_preview' => true,

    'shortcode' => '[magz_tabs] {{child_shortcode}}  [/magz_tabs]',

    'popup_title' => __('Insert Tab Shortcode', 'textdomain'),

    

    'child_shortcode' => array(

        'params' => array(

            'title' => array(

                'std' => 'Title',

                'type' => 'text',

                'label' => __('Tab Title', 'textdomain'),

                'desc' => __('Title of the tab', 'textdomain'),

            ),

            'content' => array(

                'std' => 'Tab Content',

                'type' => 'textarea',

                'label' => __('Tab Content', 'textdomain'),

                'desc' => __('Add the tabs content', 'textdomain')

            )

        ),

        'shortcode' => '[magz_tab title="{{title}}"] {{content}} [/magz_tab]',

        'clone_button' => __('Add Tab', 'textdomain')

    )

);



/*-----------------------------------------------------------------------------------*/

/*	Columns Config

/*-----------------------------------------------------------------------------------*/



$zilla_shortcodes['columns'] = array(

	'params' => array(),

	'shortcode' => ' {{child_shortcode}} ', // as there is no wrapper shortcode

	'popup_title' => __('Insert Columns Shortcode', 'textdomain'),

	'no_preview' => true,

	

	// child shortcode is clonable & sortable

	'child_shortcode' => array(

		'params' => array(

			'column' => array(

				'type' => 'select',

				'label' => __('Column Type', 'textdomain'),

				'desc' => __('Select the type, ie width of the column.', 'textdomain'),

				'options' => array(

					'magz_one_third' => 'One Third',

					'magz_one_third_last' => 'One Third Last',

					'magz_two_third' => 'Two Thirds',

					'magz_two_third_last' => 'Two Thirds Last',

					'magz_one_half' => 'One Half',

					'magz_one_half_last' => 'One Half Last',

					'magz_one_fourth' => 'One Fourth',

					'magz_one_fourth_last' => 'One Fourth Last',

					'magz_three_fourth' => 'Three Fourth',

					'magz_three_fourth_last' => 'Three Fourth Last',

					'magz_one_fifth' => 'One Fifth',

					'magz_one_fifth_last' => 'One Fifth Last',

					'magz_two_fifth' => 'Two Fifth',

					'magz_two_fifth_last' => 'Two Fifth Last',

					'magz_three_fifth' => 'Three Fifth',

					'magz_three_fifth_last' => 'Three Fifth Last',

					'magz_four_fifth' => 'Four Fifth',

					'magz_four_fifth_last' => 'Four Fifth Last',

					'magz_one_sixth' => 'One Sixth',

					'magz_one_sixth_last' => 'One Sixth Last',

					'magz_five_sixth' => 'Five Sixth',

					'magz_five_sixth_last' => 'Five Sixth Last'

				)

			),

			'content' => array(

				'std' => '',

				'type' => 'textarea',

				'label' => __('Column Content', 'textdomain'),

				'desc' => __('Add the column content.', 'textdomain'),

			)

		),

		'shortcode' => '[{{column}}] {{content}} [/{{column}}] ',

		'clone_button' => __('Add Column', 'textdomain')

	)

);





/*-----------------------------------------------------------------------------------*/

/*	CForm Config

/*-----------------------------------------------------------------------------------*/



$zilla_shortcodes['cform'] = array(

    'params' => array(),

    'no_preview' => true,

    'shortcode' => '[magz_cform]',

    'popup_title' => __('Insert Contact Form Shortcode', 'textdomain'),

);



?>