<?php

/**
 * Checks if sidebar is used on the current page
 *
 * Checks if sidebar is used on the current page based on the local (page) settings and global (Theme Options)
 * setting
 *
 * @uses ishyoboy_get_sidebar_position()
 *
 * @param integer $post_id The ID of the current post or page
 * @return bool
 */
if ( ! function_exists( 'ishyoboy_blog_categories' ) ) {
	function ishyoboy_blog_categories( $post_id = null ){
		global $ish_options;

		$return = '';

		if ( isset( $ish_options ) && isset( $ish_options['show_blog_categories'] ) && '1' == $ish_options['show_blog_categories'] ){
			$return .= '<div class="wpb_row vc_row-fluid ish-row-notfull ish-row_section ish-section-filter"><div class="ish-vc_row_inner">';

			$return .= '<div class="ish-sc-element ish-sc_headline ish-center ish-h3">' . __( 'Categories', 'ishyoboy') . '</div>';

			$args = array(
				'hierarchical'       => 0,
				'title_li'           => '',
				'show_option_none'   => '',
				'echo'               => 0,
			);

			$return .= '<nav><ul>';

			if ( 'page' == get_option('show_on_front') ) { $all_url = apply_filters( 'ishyoboy_sc_url', get_permalink( get_option('page_for_posts' ) ) ); }
			else { $all_url = site_url(); }

			$active_class = ( is_category() ) ? '': ' current-cat';

			$return .= '<li class="ish-all' . $active_class . '"><a href="' . $all_url . '" class="ish-all-link">' . __( 'All', 'ishyoboy' ) . '</a></li>';
			$return .= wp_list_categories( $args );
			$return .= '</ul></nav>';

			$return .= '</div></div>';
		}

		return $return;
	}
}

/**
 * Checks if masonry size set in blog post and generates the necessary classes for the masonry overview page
 *
 * @return bool
 */
if ( ! function_exists( 'ishyoboy_get_blog_masonry_size_classes' ) ) {
	function ishyoboy_get_blog_masonry_size_classes(){
		global $post, $ish_options;

		$return = '';
		if ( isset($ish_options['blog_masonry_layout_style']) && 'grid' != $ish_options['blog_masonry_layout_style'] ){
			$masonry_size = IshYoMetaBox::get('masonry_size', true, get_the_ID() );
			if ( empty( $masonry_size ) ){ $masonry_size = '1_1'; }
			$m_size = explode( '_', $masonry_size );
			$return .= ' ish-bpm-w' . $m_size[0] . ' ish-bpm-h' . $m_size[1];
		}

		return $return;
	}
}

/**
 * Returns the length of the excerpt based on the masonry grid item size
 *
 * @param string $mas_classes The string containing masonry grid size classes generated by ishyoboy_get_blog_masonry_size_classes()
 *
 * @return integer length
 */
if ( ! function_exists( 'get_masonry_excerpt_length' ) ) {
	function get_masonry_excerpt_length( $mas_classes, $has_image = false ){

		if ( !empty( $mas_classes ) ){
			if ( false !== strpos($mas_classes, '-w2') ){
				if ( false !== strpos($mas_classes, '-h2') ){
					// 2x2
					$excerpt_length = 55;
				}else{
					// 2x1
					$excerpt_length = ( $has_image ) ? 30 : 55;
				}
			}else{
				if ( false !== strpos($mas_classes, '-h2') ){
					// 1x2
					$excerpt_length = ( $has_image ) ? 15 : 55;
				}else{
					// 1x1
					$excerpt_length = ( $has_image ) ? 10 : 15;
				}
			}
		}
		else{
			$excerpt_length = 55;
		}

		return $excerpt_length;
	}
}


if ( ! function_exists( 'ishyoboy_get_masonry_post_thumbnail' ) ) {
	function ishyoboy_get_masonry_post_thumbnail(){
		global $post;

		$return = '';

		if ( has_post_thumbnail() ) {
			$return = '<div class="ish-blog-post-media">';

			// POST THUMBNAIL URL
			$thumb_size = 'theme-large';
			$img_details = '';
			$img_details = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), $thumb_size );
			$return .= '<a href="' . get_permalink() . '" style="background-image: url(\'' . $img_details[0] . '\');">';
			$return .= get_the_post_thumbnail( get_the_ID(), $thumb_size );
			$return .= '</a>';

			$return .= '</div>';
		}

		return $return;

	}
}
