<?php

/**
 *  Echoes one more field to each widget
 *
 *  Echoes one more field to each widget's form on the backend to allow the users to specify widget width. Called in
 *  "widget_form_callback" hook
 *
 * @param array $instance
 * @param array $widget
 *
 * @return array $instance to let the filter work correctly
 */
if ( !function_exists( 'ishyoboy_widget_form_extend' ) ) {
	function ishyoboy_widget_form_extend( $instance, $widget ) {
		if ( !isset($instance['widget_width']) )
			$instance['widget_width'] = '3';

		$row = "<p>\n";
		$row .= "\t<label for='widget-{$widget->id_base}-{$widget->number}-widget_width'>" . __('Widget width:', 'ishyoboy_assets') . "</label>\n";
		$row .= "\t<select name='widget-{$widget->id_base}[{$widget->number}][widget_width]' id='widget-{$widget->id_base}-{$widget->number}-widget_width' class='widefat'>";
		$row .= "\t<option value='3' " . selected( $instance['widget_width'], '3', false) . ">One fourth</option>\n";
		$row .= "\t<option value='4' " . selected( $instance['widget_width'], '4', false) . ">One third</option>\n";
		$row .= "\t<option value='6' " . selected( $instance['widget_width'], '6', false) . ">One half</option>\n";
		$row .= "\t<option value='12' " . selected( $instance['widget_width'], '12', false) . ">One full</option>\n";
		$row .= "\t<option value='8' " . selected( $instance['widget_width'], '8', false) . ">Two thirds</option>\n";
		$row .= "\t<option value='9' " . selected( $instance['widget_width'], '9', false) . ">Three fourths</option>\n";
		$row .= "\t</select>\n";
		$row .= "</p>\n";

		echo $row;
		return $instance;
	}
}

/**
 *  Allows the update of a new widget field
 *
 *  Allows the update of a new widget field (when widget form saved) generated by the "ishyoboy_widget_form_extend"
 *  which adds widget width field.
 *
 * @param array $instance
 * @param array $new_instance
 * @param array $old_instance
 *
 * @return array $instance The updated value
 */
if ( !function_exists( 'ishyoboy_widget_update' ) ) {
	function ishyoboy_widget_update( $instance, $new_instance, $old_instance ) {
		$instance['widget_width'] = $new_instance['widget_width'];
		return $instance;
	}
}