<?php
//主题变量

include('includes/theme-option.php');
add_theme_support( 'post-thumbnails' );
function dm_strimwidth($str ,$start , $width ,$trimmarker ){$output = preg_replace('/^(?:[\x00-\x7F]|[\xC0-\xFF][\x80-\xBF]+){0,'.$start.'}((?:[\x00-\x7F]|[\xC0-\xFF][\x80-\xBF]+){0,'.$width.'}).*/s','\1',$str); return $output.$trimmarker;};
if ( function_exists('register_nav_menus') ) {
    register_nav_menus(array(
         'menu' => '头部菜单',
	 'footer-menu' => '底部友情链接',	
    ));
}
add_filter('show_admin_bar', '__return_false');

add_filter('gettext_with_context', 'disable_open_sans', 888, 4 );
function disable_open_sans( $translations, $text, $context, $domain )
{
if ( 'Open Sans font: on or off' == $context && 'on' == $text ) {
$translations = 'off';
}
return $translations;
}



//去除头部冗余代码
	remove_action( 'wp_head',   'feed_links_extra', 3 ); 
	remove_action( 'wp_head',   'rsd_link' ); 
	remove_action( 'wp_head',   'wlwmanifest_link' ); 
	remove_action( 'wp_head',   'index_rel_link' ); 
	remove_action( 'wp_head',   'start_post_rel_link', 10, 0 ); 
	remove_action( 'wp_head',   'wp_generator' ); 

//阻止站内PingBack
	if( dopt('d_pingback_b') ){
		add_action('pre_ping','deel_noself_ping');   
	}

//移除自动保存和修订版本
	if( dopt('d_autosave_b') ){
		add_action('wp_print_scripts','deel_disable_autosave' );
		remove_action('pre_post_update','wp_save_post_revision' );
	}




//翻页导航
function pagenavi($range = 9){
	global $paged, $wp_query;
	if ( !$max_page ) {$max_page = $wp_query->max_num_pages;}
	if($max_page > 1){if(!$paged){$paged = 1;}
	if($paged != 1){echo "<a href='" . get_pagenum_link(1) . "' class='fir_las' title=''>首页</a>";}
	previous_posts_link('上页');
    if($max_page > $range){
		if($paged < $range){for($i = 1; $i <= ($range + 1); $i++){echo "<a href='" . get_pagenum_link($i) ."'";
		if($i==$paged)echo " id='pageactive'";echo ">$i</a>";}}
    elseif($paged >= ($max_page - ceil(($range/2)))){
		for($i = $max_page - $range; $i <= $max_page; $i++){echo "<a href='" . get_pagenum_link($i) ."'";
		if($i==$paged)echo " id='pageactive'";echo ">$i</a>";}}
	elseif($paged >= $range && $paged < ($max_page - ceil(($range/2)))){
		for($i = ($paged - ceil($range/2)); $i <= ($paged + ceil(($range/2))); $i++){echo "<a href='" . get_pagenum_link($i) ."'";if($i==$paged) echo " id='pageactive'";echo ">$i</a>";}}}
    else{for($i = 1; $i <= $max_page; $i++){echo "<a href='" . get_pagenum_link($i) ."'";
    if($i==$paged)echo " id='pageactive'";echo ">$i</a>";}}

	next_posts_link('下页');
    if($paged != $max_page){echo "<a href='" . get_pagenum_link($max_page) . "' class='extend' title=''>尾页</a>";}
    }
}

function colorCloud($text) {
	$text = preg_replace_callback('|<a (.+?)>|i','colorCloudCallback', $text);
	return $text;
}
function colorCloudCallback($matches) {
	$text = $matches[1];
	$color = dechex(rand(0,16777215));
	$pattern = '/style=(\'|\")(.*)(\'|\")/i';
	$text = preg_replace($pattern, "style=", $text);
	return "<li><a $text>";
}
add_filter('wp_tag_cloud', 'colorCloud', 1);

function customTitle($limit) {
    $title = get_the_title($post->ID);
    if(strlen($title) > $limit) {
        $title = substr($title, 0, $limit) . '...';
    }
 
    echo $title;
}

//面包屑
function dimox_breadcrumbs() {
 
  $delimiter = '&raquo;';
  $name = 'Home'; //text for the 'Home' link
  $currentBefore = '<span>';
  $currentAfter = '</span>';
 
  if ( !is_home() && !is_front_page() || is_paged() ) {
 
    echo '<div id="crumbs">';
 
    global $post;
    $home = get_bloginfo('url');
    echo '' . $name . ' ' . $delimiter . ' ';
 
    if ( is_category() ) {
      global $wp_query;
      $cat_obj = $wp_query->get_queried_object();
      $thisCat = $cat_obj->term_id;
      $thisCat = get_category($thisCat);
      $parentCat = get_category($thisCat->parent);
      if ($thisCat->parent != 0) echo(get_category_parents($parentCat, TRUE, ' ' . $delimiter . ' '));
      echo $currentBefore . 'Archive by category &#39;';
      single_cat_title();
      echo '&#39;' . $currentAfter;
 
    } elseif ( is_day() ) {
      echo '' . get_the_time('Y') . ' ' . $delimiter . ' ';
      echo '' . get_the_time('F') . ' ' . $delimiter . ' ';
      echo $currentBefore . get_the_time('d') . $currentAfter;
 
    } elseif ( is_month() ) {
      echo '' . get_the_time('Y') . ' ' . $delimiter . ' ';
      echo $currentBefore . get_the_time('F') . $currentAfter;
 
    } elseif ( is_year() ) {
      echo $currentBefore . get_the_time('Y') . $currentAfter;
 
    } elseif ( is_single() ) {
      $cat = get_the_category(); $cat = $cat[0];
      echo get_category_parents($cat, TRUE, ' ' . $delimiter . ' ');
      echo $currentBefore;
      the_title();
      echo $currentAfter;
 
    } elseif ( is_page() && !$post->post_parent ) {
      echo $currentBefore;
      the_title();
      echo $currentAfter;
 
    } elseif ( is_page() && $post->post_parent ) {
      $parent_id  = $post->post_parent;
      $breadcrumbs = array();
      while ($parent_id) {
        $page = get_page($parent_id);
        $breadcrumbs[] = '' . get_the_title($page->ID) . '';
        $parent_id  = $page->post_parent;
      }
      $breadcrumbs = array_reverse($breadcrumbs);
      foreach ($breadcrumbs as $crumb) echo $crumb . ' ' . $delimiter . ' ';
      echo $currentBefore;
      the_title();
      echo $currentAfter;
 
    } elseif ( is_search() ) {
      echo $currentBefore . 'Search results for &#39;' . get_search_query() . '&#39;' . $currentAfter;
 
    } elseif ( is_tag() ) {
      echo $currentBefore . 'Posts tagged &#39;';
      single_tag_title();
      echo '&#39;' . $currentAfter;
 
    } elseif ( is_author() ) {
       global $author;
      $userdata = get_userdata($author);
      echo $currentBefore . 'Articles posted by ' . $userdata->display_name . $currentAfter;
 
    } elseif ( is_404() ) {
      echo $currentBefore . 'Error 404' . $currentAfter;
    }
 
    if ( get_query_var('paged') ) {
      if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ' (';
      echo __('Page') . ' ' . get_query_var('paged');
      if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ')';
    }
 
    echo '</div>';
 
  }
}



//添加特色缩略图支持
if ( function_exists('add_theme_support') )add_theme_support('post-thumbnails');
 
//输出缩略图地址 From wpdaxue.com
function post_thumbnail_src(){
    global $post;
	if( $values = get_post_custom_values("thumb") ) {	//输出自定义域图片地址
		$values = get_post_custom_values("thumb");
		$post_thumbnail_src = $values [0];
	} elseif( has_post_thumbnail() ){    //如果有特色缩略图，则输出缩略图地址
        $thumbnail_src = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID),'full');
		$post_thumbnail_src = $thumbnail_src [0];
    } else {
		$post_thumbnail_src = '';
		ob_start();
		ob_end_clean();
		$output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $post->post_content, $matches);
		$post_thumbnail_src = $matches [1] [0];   //获取该图片 src
		if(empty($post_thumbnail_src)){	//如果日志中没有图片，则显示随机图片
			$random = mt_rand(1, 10);
			echo get_bloginfo('template_url');
			echo '/images/pic/'.$random.'.jpg';
			//如果日志中没有图片，则显示默认图片
			//echo '/images/default_thumb.jpg';
		}
	};
	echo $post_thumbnail_src;
}


function dopt($e){
    return stripslashes(get_option($e));
}

function time_since($older_date, $newer_date = false)
{
    $chunks = array(
    array(60 * 60 * 24 * 365 , '年'),
    array(60 * 60 * 24 * 30 , '月'),
    array(60 * 60 * 24 * 7, '周'),
    array(60 * 60 * 24 , '天'),
    array(60 * 60 , '小时'),
    array(60 , '分钟'),
    );
     
    $newer_date = ($newer_date == false) ? (time()+(60*60*get_settings("gmt_offset"))) : $newer_date;
    $since = $newer_date - abs(strtotime($older_date));
     
    //根据自己的需要调整时间段，下面的24则表示小时，根据需要调整吧
    if($since < 60 * 60 * 24){
    for ($i = 0, $j = count($chunks); $i < $j; $i++)
    {
    $seconds = $chunks[$i][0];
    $name = $chunks[$i][1];
      
    if (($count = floor($since / $seconds)) != 0)
    {
    break;
    }
    }
     
    $out = ($count == 1) ? '1 '.$name : "$count {$name}";
    return $out." 前";
    }else{
    the_time(get_option('date_format'));
    }
}

//全部设置结束
?>
<?php

//访问计数
function record_visitors(){
	if (is_singular()) {global $post;
	 $post_ID = $post->ID;
	  if($post_ID) 
	  {
		  $post_views = (int)get_post_meta($post_ID, 'views', true);
		  if(!update_post_meta($post_ID, 'views', ($post_views+1))) 
		  {
			add_post_meta($post_ID, 'views', 1, true);
		  }
	  }
	}
}
add_action('wp_head', 'record_visitors');  
function post_views($before = '(点击 ', $after = ' 次)', $echo = 1)
{
  global $post;
  $post_ID = $post->ID;
  $views = (int)get_post_meta($post_ID, 'views', true);
  if ($echo) echo $before, number_format($views), $after;
  else return $views;
};

  
 

?>
<?php	

/* 某段时间内最热文章
 * Reference: http://www.wprecipes.com/rarst-asked-how-to-get-most-commented-posts-of-the-week
 * Edit: zwwooooo
 */
function most_comm_posts($days=7, $nums=10) { //$days参数限制时间值，单位为'天'，默认是7天；$nums是要显示文章数量
	global $wpdb;
	$today = date("Y-m-d H:i:s"); //获取今天日期时间
	$daysago = date( "Y-m-d H:i:s", strtotime($today) - ($days * 24 * 60 * 60) );  //Today - $days
	$result = $wpdb->get_results("SELECT comment_count, ID, post_title, post_date FROM $wpdb->posts WHERE post_date BETWEEN '$daysago' AND '$today' ORDER BY comment_count DESC LIMIT 0 , $nums");
	$output = '';
	if(empty($result)) {
		$output = '<li>None data.</li>';
	} else {
		foreach ($result as $topten) {
			$postid = $topten->ID;
			$title = $topten->post_title;
			$commentcount = $topten->comment_count;
			if ($commentcount != 0) {
				$output .= '<li><a href="'.get_permalink($postid).'" title="'.$title.'">'.$title.'</a> ('.$commentcount.')</li>';
			}
		}
	}
	echo $output;
}

//让WordPress支持用户名或邮箱登录
function dr_email_login_authenticate( $user, $username, $password ) {
	if ( is_a( $user, 'WP_User' ) )
		return $user;
 
	if ( !empty( $username ) ) {
		$username = str_replace( '&', '&', stripslashes( $username ) );
		$user = get_user_by( 'email', $username );
		if ( isset( $user, $user->user_login, $user->user_status ) && 0 == (int) $user->user_status )
			$username = $user->user_login;
	}
 
	return wp_authenticate_username_password( null, $username, $password );
}
remove_filter( 'authenticate', 'wp_authenticate_username_password', 20, 3 );
add_filter( 'authenticate', 'dr_email_login_authenticate', 20, 3 );
 
//替换"用户名"为"用户名 / 邮箱"
function username_or_email_login() {
	if ( 'wp-login.php' != basename( $_SERVER['SCRIPT_NAME'] ) )
		return;
 
	?><script type="text/javascript">
	// Form Label
	if ( document.getElementById('loginform') )
		document.getElementById('loginform').childNodes[1].childNodes[1].childNodes[0].nodeValue = '<?php echo esc_js( __( '用户名/邮箱', 'email-login' ) ); ?>';
 
	// Error Messages
	if ( document.getElementById('login_error') )
		document.getElementById('login_error').innerHTML = document.getElementById('login_error').innerHTML.replace( '<?php echo esc_js( __( '用户名' ) ); ?>', '<?php echo esc_js( __( '用户名/邮箱' , 'email-login' ) ); ?>' );
	</script><?php
}
add_action( 'login_form', 'username_or_email_login' );


if(is_admin()) {
  $current_user = wp_get_current_user();
  if($current_user->roles[0] == get_option('default_role')) {
    wp_safe_redirect( home_url() );
    exit();
  }
}

function __my_registration_redirect() {
  // 这里设置的是跳转到首页，要换成其他页面
  // 可以将home_url()改成你指定的URL
  // 如 return 'http://www.baidu.com';
  return home_url();
}
add_filter( 'registration_redirect', '__my_registration_redirect' );


function ludou_non_strict_login( $username, $raw_username, $strict ) {
    if( !$strict )
        return $username;

    return sanitize_user(stripslashes($raw_username), false);
}
add_filter('sanitize_user', 'ludou_non_strict_login', 10, 3);



//日志与评论的相对时间显示
function ATheme_time_diff( $time_type ) {
    switch( $time_type ){
        case 'comment':    //如果是评论的时间
            $time_diff = current_time('timestamp') - get_comment_time('U');
            if( $time_diff <= 86400 )    //24 小时之内
                echo human_time_diff(get_comment_time('U'), current_time('timestamp')).' 之前';    //显示格式 OOXX 之前
            else
                printf(__('%1$s at %2$s'), get_comment_date(),  get_comment_time());    //显示格式 X年X月X日 OOXX 时
            break;
        case 'post';    //如果是日志的时间
            $time_diff = current_time('timestamp') - get_the_time('U');
            if( $time_diff <= 86400 )
                echo human_time_diff(get_the_time('U'), current_time('timestamp')).'前';
            else
                the_time('Y-m-d H:i');
            break;
    }
}

//显示最近评论次数
function ATheme_WelcomeCommentAuthorBack($email = ''){
	if(empty($email)){
		return;
	}
	global $wpdb;
	$past_30days = gmdate('Y-m-d H:i:s',((time()-(24*60*60*30))+(get_option('gmt_offset')*3600)));
	$sql = "SELECT count(comment_author_email) AS times FROM $wpdb->comments
					WHERE comment_approved = '1'
					AND comment_author_email = '$email'
					AND comment_date >= '$past_30days'";
	$times = $wpdb->get_results($sql);
	$times = ($times[0]->times) ? $times[0]->times : 0;
	$message = $times ? sprintf(__('过去30天内您评论了<strong>%1$s</strong>次，感谢关注~' ), $times) : '您很久都没有留言了，这次想说点什么吗？';
	return $message;
}


//文章评论功能
				function h_comment($comment, $args, $depth) {$GLOBALS['comment'] = $comment;
				global $commentcount,$wpdb, $post;
				if(!$commentcount) { 
					$comments = $wpdb->get_results("SELECT * FROM $wpdb->comments WHERE comment_post_ID = $post->ID AND comment_type = '' AND comment_approved = '1' AND !comment_parent");
					$cnt = count($comments);
					$page = get_query_var('cpage');
					$cpp=get_option('comments_per_page');
					if (ceil($cnt / $cpp) == 1 || ($page > 1 && $page  == ceil($cnt / $cpp))) {
						$commentcount = $cnt + 1;
					} else {$commentcount = $cpp * $page + 1;}
				}?>
				<li <?php comment_class(); ?> id="comment-<?php comment_ID() ?>">
					<div id="div-comment-<?php comment_ID() ?>" class="comment-body">
						<?php $add_below = 'div-comment'; ?>
						<div class="comment-author vcard">
							<?php echo get_avatar( $comment, 40 , '',$comment->comment_author); ?>
							<div class="floor">
								<?php 
								if(!$parent_id = $comment->comment_parent){switch ($commentcount){
									case 2 :echo "沙发";--$commentcount;break;
									case 3 :echo "板凳";--$commentcount;break;
									case 4 :echo "地板";--$commentcount;break;
									default:printf('%1$s楼', --$commentcount);}}
									?>
								</div>
								<strong><?php comment_author_link() ?></strong>:<?php edit_comment_link('编辑','&nbsp;&nbsp;',''); ?></div>
								<?php if ( $comment->comment_approved == '0' ) : ?>
									<span style="color:#C00; font-style:inherit">您的评论正在等待审核中...</span>
									<br />			
								<?php endif; ?>
								<?php comment_text() ?>
								<div class="clear"></div><span class="datetime"><?php comment_date('Y-m-d') ?> <?php comment_time() ?> </span> <span class="reply"><?php comment_reply_link(array_merge( $args, array('reply_text' => '[回复]', 'add_below' =>$add_below, 'depth' => $depth, 'max_depth' => $args['max_depth']))); ?></span>
							</div>
							<?php
						}
						function h_end_comment() {echo '</li>';};
	//自定义表情地址
						function custom_smilies_src($src, $img){return get_template_directory_uri().'/images/smilies/' . $img;}
						add_filter('smilies_src', 'custom_smilies_src', 10, 2);

//取消自己PING自己
						function no_self_ping(&$links) {
							$home = home_url();
							foreach ($links as $l => $link )
								if (0 === strpos($link, $home))
									unset($links[$l]);
							} 
							add_action( 'pre_ping', 'no_self_ping' );


//过滤代码的中文符号
							remove_filter('the_content', 'wptexturize');


function thumb_img($soContent){
$soImages = '~<img [^\>]*\ />~';
preg_match_all( $soImages, $soContent, $thePics );
$allPics = count($thePics);
if( $allPics > 0 ){ 
$count=1;//赋予1的值
foreach($thePics[0] as $v){
 if( $count == 4 ){break;}//当count等于4的时候跳出循环
 else {
     echo "<a>";
	 echo $v;
     echo "</a><div></div>";
	 }
$count++;//循环+1
}
}
else {
echo "<img src='";
echo bloginfo('template_url');
echo "/images/thumb.gif'>";
}
}


/**
 * WordPress 显示最近注册的用户
 * http://www.wpdaxue.com/display-recently-registered-users.html
 */
function wpb_recently_registered_users() { 
	global $wpdb;
	$recentusers = '<ul class="recently-user">';
	$usernames = $wpdb->get_results("SELECT user_nicename, user_url, user_email FROM $wpdb->users ORDER BY ID DESC LIMIT 5"); //只显示最近注册的 5 个用户
	foreach ($usernames as $username) {
		if (!$username->user_url) : //如果有用户没有填写网站，就只显示头像和用户名
			$recentusers .= '<li>' .get_avatar($username->user_email, 45) .$username->user_nicename."</a><div><p>网页设计师   (人气：830)</p></div></li>";
		else : //如果用户填写了网站，就给用户名添加链接
			$recentusers .= '<li>' .get_avatar($username->user_email, 45).'<a href="'.$username->user_url.'" class="ithimg">'.$username->user_nicename."</a><div><p>网页设计师   (人气：830)</p></div></li>";
		endif;
	}
	$recentusers .= '</ul>';
	return $recentusers;  
}
//添加简码
add_shortcode('wpb_newusers', 'wpb_recently_registered_users');

function wpfp_get_current_count() {
    global $wpdb;
	$current_post = get_the_ID();
    $query = "SELECT post_id, meta_value, post_status FROM $wpdb->postmeta";
    $query .= " LEFT JOIN $wpdb->posts ON post_id=$wpdb->posts.ID";
    $query .= " WHERE post_status='publish' AND meta_key='wpfp_favorites' AND post_id = '".$current_post."'";
    $results = $wpdb->get_results($query);
    if ($results) {
        foreach ($results as $o):
            echo $o->meta_value;
        endforeach;
    }else {echo( '0' );}
}


function zsofa_most_active_friends($friends_num = 10) {
    global $wpdb;
    $counts = $wpdb->get_results("SELECT COUNT(comment_author) AS cnt, comment_author, comment_author_url, comment_author_email FROM (SELECT * FROM $wpdb->comments LEFT OUTER JOIN $wpdb->posts ON ($wpdb->posts.ID=$wpdb->comments.comment_post_ID) WHERE comment_date > date_sub( NOW(), INTERVAL 1 MONTH ) AND user_id='0' AND comment_author != 'zwwooooo' AND post_password='' AND comment_approved='1' AND comment_type='') AS tempcmt GROUP BY comment_author ORDER BY cnt DESC LIMIT $friends_num");
    foreach ($counts as $count) {
    $c_url = $count->comment_author_url;
    if ($c_url == '') $c_url = get_bloginfo('url');
    $mostactive .= '<li>' . '<a class="ithimg" href="'. $c_url . '" title="' . $count->comment_author . ' ('. $count->cnt . 'comments">' . get_avatar($count->comment_author_email, 46) . '</a><div><a href="'. $c_url . '" target="_blank">' . $count->comment_author . '</a><p>留下了'. $count->cnt . '口水</p></div></li>';
    }
    return $mostactive;
}

function all_img($soContent){

$soImages = '~<img [^\>]*\ />~'; //这段话的意思：获取文章里面的图片

preg_match_all( $soImages, $soContent, $thePics );

$allPics = count($thePics);//通过正则表达式判断是否存在图片

preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i',$soContent, $matches);

$cnt = count($matches[1]);// 获取文章里面的图片数量

if( $allPics > 0 ){  // 判断2的原因是图片数量小于2的文章，不需要显示缩略图了

$count=1;//赋予1的值

foreach($thePics[0] as $v){

if( $count == 4 ){break;}//当count等于12的时候跳出循环  意思是获取12张图片 

else {

$pattern ='<img.*?src="(.*?)">';

preg_match($pattern,$v,$matches);// 通过正则表达式获取图片里面的路径



echo "<img src=/wp-content/themes/ue/timthumb.php?src=".$matches[1]."&h=68&w=100&zc=1 alt=" . get_the_title() . ">";



}

$count++;//循环+1

}
}
else {
// 可以自己搞点什么，没有图片的时需要提示什么
}
}


/// get_most_viewed_format
/// 函数作用：取得阅读最多的文章
function get_most_viewed_format($mode = '', $limit = 10, $show_date = 0, $term_id = 0, $beforetitle= '(', $aftertitle = ')', $beforedate= '(', $afterdate = ')', $beforecount= '(', $aftercount = ')') {
  global $wpdb, $post;
  $output = '';
  $mode = ($mode == '') ? 'post' : $mode;
  $type_sql = ($mode != 'both') ? "AND post_type='$mode'" : '';
  $term_sql = (is_array($term_id)) ? "AND $wpdb->term_taxonomy.term_id IN (" . join(',', $term_id) . ')' : ($term_id != 0 ? "AND $wpdb->term_taxonomy.term_id = $term_id" : '');
  $term_sql.= $term_id ? " AND $wpdb->term_taxonomy.taxonomy != 'link_category'" : '';
  $inr_join = $term_id ? "INNER JOIN $wpdb->term_relationships ON ($wpdb->posts.ID = $wpdb->term_relationships.object_id) INNER JOIN $wpdb->term_taxonomy ON ($wpdb->term_relationships.term_taxonomy_id = $wpdb->term_taxonomy.term_taxonomy_id)" : '';
 
  // database query
  $most_viewed = $wpdb->get_results("SELECT ID, post_date, post_title, (meta_value+0) AS views FROM $wpdb->posts LEFT JOIN $wpdb->postmeta ON ($wpdb->posts.ID = $wpdb->postmeta.post_id) $inr_join WHERE post_status = 'publish' AND post_password = '' $term_sql $type_sql AND meta_key = 'views' GROUP BY ID ORDER BY views DESC LIMIT $limit");
  if ($most_viewed) {
   foreach ($most_viewed as $viewed) {
    $post_ID    = $viewed->ID;
    $post_views = number_format($viewed->views);
    $post_title = esc_attr($viewed->post_title);
    $get_permalink = esc_attr(get_permalink($post_ID));
    $output .= "<li>$beforetitle$post_title$aftertitle";
    if ($show_date) {
      $posted = date(get_option('date_format'), strtotime($viewed->post_date));
      $output .= "$beforedate $posted $afterdate";
    }
    $output .= "$beforecount $post_views $aftercount</li>";
   }
  } else {
   $output = "<li>N/A</li>n";
  }
  echo $output;
}


//头像
function get_ssl_avatar($avatar) {
   $avatar = preg_replace('/.*\/avatar\/(.*)\?s=([\d]+)&.*/','<img src="https://secure.gravatar.com/avatar/$1?s=$2" class="avatar avatar-$2" height="$2" width="$2">',$avatar);
   return $avatar;
}
add_filter('get_avatar', 'get_ssl_avatar');



?>