<?php
include('option/dtheme.php');
include("option/widget.php");
include("option/cat-posts.php");
//禁止自动保存草稿和修订版本 [开始]
remove_action('pre_post_update', 'wp_save_post_revision' );
add_action( 'wp_print_scripts', 'disable_autosave' );
function disable_autosave() {
wp_deregister_script('autosave');
}
//隐藏前台顶部工具条
add_filter('show_admin_bar', '__return_false');
//修复4.2表情bug
function disable_emoji9s_tinymce( $plugins ) {
	if ( is_array( $plugins ) ) {
		return array_diff( $plugins, array( 'wpemoji' ) );
	} else {
		return array();
	}
}

function remove_emoji9s() {
	remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
	remove_action( 'admin_print_scripts', 'print_emoji_detection_script' );
	remove_action( 'wp_print_styles', 'print_emoji_styles' );
	remove_action( 'admin_print_styles', 'print_emoji_styles' );
	remove_filter( 'the_content_feed', 'wp_staticize_emoji' );
	remove_filter( 'comment_text_rss', 'wp_staticize_emoji' );
	remove_filter( 'wp_mail', 'wp_staticize_emoji_for_email' );
	add_filter( 'tiny_mce_plugins', 'disable_emoji9s_tinymce' );
}

add_action( 'init', 'remove_emoji9s' );

//移除后台板块
function example_remove_dashboard_widgets() {
	global $wp_meta_boxes;
	unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_primary']);
	// 移除 "其它 WordPress 新闻" 模块
	unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_secondary']);
	// 移除 "概况" 模块
	unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_right_now']);
	}
add_action('wp_dashboard_setup', 'example_remove_dashboard_widgets' );

//禁止自动保存草稿和修订版本 [结束]
function tangstyle_page_menu_args( $args ) {
	$args['show_home'] = true;
	return $args;
}
add_filter( 'wp_page_menu_args', 'tangstyle_page_menu_args' );

if(function_exists('register_sidebar')){
	register_sidebar(
	array('name'=>'首页侧边栏(只在首页显示)',
	        'id'=>'widget_popular1',
			'before_widget'=>'<div id="%1$s" class="block">',
			'after_widget'=>'</div>',
			'before_title'=>'<h3>',
			'after_title'=>'</h3>',
			));}
if(function_exists('register_sidebar')){
	register_sidebar(
	array('name'=>'分类页侧边(只在分类页显示)',
	        'id'=>'widget_popular2',
			'before_widget'=>'<div id="%1$s" class="block">',
			'after_widget'=>'</div>',
			'before_title'=>'<h3>',
			'after_title'=>'</h3>',
			));}
if(function_exists('register_sidebar')){
	register_sidebar(
	array('name'=>'文章页侧边(只在文章页显示)',
	        'id'=>'widget_popular3',
			'before_widget'=>'<div id="%1$s" class="block">',
			'after_widget'=>'</div>',
			'before_title'=>'<h3>',
			'after_title'=>'</h3>',
			));}
if(function_exists('register_sidebar')){
	register_sidebar(
	array('name'=>'页面侧边(只在页面显示)',
	        'id'=>'widget_popular5',
			'before_widget'=>'<div id="%1$s" class="block">',
			'after_widget'=>'</div>',
			'before_title'=>'<h3>',
			'after_title'=>'</h3>',
			));}

if ( ! function_exists( 'tangstyle_content_nav' ) ) :
	register_nav_menus(array(
         'top-menu' => __( '左侧菜单' ),
         'second-menu' => __( '右侧菜单' ),
         'yidong-menu' => __( '移动菜单' )
      )
   );

function inkthemes_nav() {
if (function_exists('wp_nav_menu'))
wp_nav_menu(array('theme_location' => 'top-menu', 'container' =>'','menu_id'=>'menu','menu_class' => 'menu', 'fallback_cb' => 'inkthemes_nav_fallback'));
else
inkthemes_nav_fallback();
}
function inkthemes_nav_fallback() {
?>
<ul id="menu" class="menu">
<?php
wp_list_pages('title_li=&show_home=1&sort_column=menu_order');
?>
</ul>
<?php
}
function inkthemes_nav1() {
if (function_exists('wp_nav_menu'))
wp_nav_menu(array('theme_location' => 'second-menu','container' =>'','menu_id'=>'menus','menu_class' => 'menu', 'fallback_cb' => 'inkthemes_nav1_fallback'));
else
inkthemes_nav1_fallback();
}
function inkthemes_nav1_fallback() {
?>
<ul id="menus" class="menu">
<?php
wp_list_pages('title_li=&show_home=1&sort_column=menu_order');
?>
</ul>
<?php
}
function inkthemes_nav2() {
if (function_exists('wp_nav_menu'))
wp_nav_menu(array('theme_location' => 'yidong-menu', 'container' =>'','menu_id'=>'navs','menu_class' => 'menu', 'fallback_cb' => 'inkthemes_nav2_fallback'));
else
inkthemes_nav2_fallback();
}
function inkthemes_nav2_fallback() {
?>
<ul id="navs" class="menu">
<?php
wp_list_cats('title_li=&show_home=1&sort_column=menu_order');
?>
</ul>
<?php
}


//缩略图获取
function dm_the_thumbnail() {  
    global $post;  
    if ( has_post_thumbnail() ) {  
        echo '<a rel="external nofollow" href="'.get_permalink().'"  title="'.get_the_title().'" >'; 
		$domsxe = simplexml_load_string(get_the_post_thumbnail());
		$thumbnailsrc = $domsxe->attributes()->src;  
		echo '<img  width="140px" height="110px" src="'.$thumbnailsrc.'" alt="'.trim(strip_tags( $post->post_title )).'" />';
        echo '</a>';  
    } else {
        $content = $post->post_content;  
        preg_match_all('/<img.*?(?: |\\t|\\r|\\n)?src=[\'"]?(.+?)[\'"]?(?:(?: |\\t|\\r|\\n)+.*?)?>/sim', $content, $strResult, PREG_PATTERN_ORDER);  
        $n = count($strResult[1]); 
		$random = mt_rand(1, 5);
        if($n > 0){
            echo '<a rel="external nofollow" href="'.get_permalink().'" title="'.get_the_title().'"><img src="'.$strResult[1][0].'" alt="'.get_the_title().'" title="'.get_the_title().'" width="140px" height="110px"/></a>';  
        }else {
            echo '<a rel="external nofollow" href="'.get_permalink().'" title="'.get_the_title().'"><img src="'.get_bloginfo('template_url').'/images/random/'.$random.'.jpg" alt="'.get_the_title().'" title="'.get_the_title().'" width="140px" height="110px"/></a>';  
        }  
    }  
}
add_theme_support( 'post-thumbnails' );

// 禁止无中文留言
function refused_spam_comments( $comment_data ) {
$pattern = '/[一-龥]/u';  
if(!preg_match($pattern,$comment_data['comment_content'])) {
wp_die('评论必须含中文！返回  <a href="javascript:history.back(-1);">上一页</a>  或  <a href="/">网站首页</a>');
}
return( $comment_data );
}
add_filter('preprocess_comment','refused_spam_comments');

//wordpress评论回复邮箱和名称
function new_from_name($email){
    $wp_from_name = get_option('blogname');
    return $wp_from_name;
}

function new_from_email($email) {
    $wp_from_email = get_option('admin_email');
    return $wp_from_email;
}
add_filter('wp_mail_from_name', 'new_from_name');
add_filter('wp_mail_from', 'new_from_email');

//侧边栏
function unregister_default_widgets() {
    unregister_widget('WP_Widget_Pages');
    unregister_widget('WP_Widget_Calendar');
    unregister_widget('WP_Widget_Links');
    unregister_widget('WP_Widget_Meta');
	unregister_widget('WP_Widget_Text');
	unregister_widget('WP_Widget_Archives');
    unregister_widget('WP_Widget_Search');
    unregister_widget('WP_Widget_Categories');
    unregister_widget('WP_Widget_Recent_Posts');
    unregister_widget('WP_Widget_Recent_Comments');
    unregister_widget('WP_Widget_RSS');
    unregister_widget('WP_Widget_Tag_Cloud');
    unregister_widget('WP_Nav_Menu_Widget');
}
add_action('widgets_init', 'unregister_default_widgets', 11);

//面包屑导航
function dimox_breadcrumbs() {
  $showOnHome = 0; // 1 - show breadcrumbs on the homepage, 0 - don't show
  $delimiter = ''; // delimiter between crumbs
  $home = ''; // text for the 'Home' link
  $showCurrent = 1; // 1 - show current post/page title in breadcrumbs, 0 - don't show
  $before = ''; // tag before the current crumb
  $after = ''; // tag after the current crumb
  global $post;
  $homeLink = get_bloginfo('url');
  if (is_home() || is_front_page()) {
    if ($showOnHome == 1) echo '<a href="' . $homeLink . '">' . $home . '</a>';
  } else {
    echo '';
    if ( is_category() ) {
      $thisCat = get_category(get_query_var('cat'), false);
      if ($thisCat->parent != 0) echo get_category_parents($thisCat->parent, TRUE, ' ' . $delimiter . ' ');
      echo $before . '【' . single_cat_title('', false) . '】相关文章' . $after;
    } elseif ( is_search() ) {
      echo $before . '搜索【' . get_search_query() . '】相关文章' . $after;
    } elseif ( is_month() ) {
      echo $before . '【' . get_the_time('Y') . ' '. get_the_time('F') .'】的存档' . $after;
    } elseif ( is_single() && !is_attachment() ) {
      if ( get_post_type() != 'post' ) {
        $post_type = get_post_type_object(get_post_type());
        $slug = $post_type->rewrite;
        echo '<a href="' . $homeLink . '/' . $slug['slug'] . '/">' . $post_type->labels->singular_name . '</a>';
        if ($showCurrent == 1) echo ' ' . $delimiter . '正文内容' ;
      } else {
        $cat = get_the_category(); $cat = $cat[0];
        $cats = get_category_parents($cat, TRUE, ' ' . $delimiter . ' ');
        if ($showCurrent == 0) $cats = preg_replace("#^(.+)\s$delimiter\s$#", "$1", $cats);
        echo $cats;
        if ($showCurrent == 1) echo "<span class='current'>正文内容</span>" ;
      }
    } elseif ( !is_single() && !is_page() && get_post_type() != 'post' && !is_404() ) {
      $post_type = get_post_type_object(get_post_type());
      echo $before . $post_type->labels->singular_name . $after;
    } elseif ( is_attachment() ) {
      $parent = get_post($post->post_parent);
      $cat = get_the_category($parent->ID); $cat = $cat[0];
      echo get_category_parents($cat, TRUE, ' ' . $delimiter . ' ');
      echo '<a href="' . get_permalink($parent) . '">' . $parent->post_title . '</a>';
      if ($showCurrent == 1) echo ' ' . $delimiter . ' ' . $before . get_the_title() . $after;
    } elseif ( is_page() && !$post->post_parent ) {
      if ($showCurrent == 1) echo $before . get_the_title() . $after;
    } elseif ( is_page() && $post->post_parent ) {
      $parent_id  = $post->post_parent;
      $breadcrumbs = array();
      while ($parent_id) {
        $page = get_page($parent_id);
        $breadcrumbs[] = '<a href="' . get_permalink($page->ID) . '">' . get_the_title($page->ID) . '</a>';
        $parent_id  = $page->post_parent;
      }
      $breadcrumbs = array_reverse($breadcrumbs);
      for ($i = 0; $i < count($breadcrumbs); $i++) {
        echo $breadcrumbs[$i];
        if ($i != count($breadcrumbs)-1) echo ' ' . $delimiter . ' ';
      }
      if ($showCurrent == 1) echo ' ' . $delimiter . ' ' . $before . get_the_title() . $after;
    } elseif ( is_tag() ) {
      echo $before . '【' . single_tag_title('', false) . '】相关文章' . $after;
    } elseif ( is_author() ) {
       global $author;
      $userdata = get_userdata($author);
      echo $before . 'Articles posted by ' . $userdata->display_name . $after;
    } elseif ( is_404() ) {
      echo $before . 'Error 404' . $after;
    }
    if ( get_query_var('paged') ) {
      if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ' (';
      echo __('Page') . ' ' . get_query_var('paged');
      if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ')';
    }
    echo '';
  }
} // end dimox_breadcrumbs()

// 评论代码
// 评论代码
function custom_comment($comment, $args, $depth) {
   $GLOBALS['comment'] = $comment; 
   	global $commentcount;
	if(!$commentcount) {
		$commentcount = 0;
	}
?>
   <li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
     <div id="comment-<?php comment_ID(); ?>">
         <div class="comment-author">
                     <?php
					$author_class = '';
					if (function_exists('get_avatar') && get_option('show_avatars')) {
						$author_class = 'with_avatar';
						echo get_avatar( $comment, 36,'',$comment->comment_author);
					}
				?>
                <div class="author_info">
               <span class="lou">
				<a href="#comment-<?php comment_ID() ?>"><?php
					if(!$parent_id = $comment->comment_parent){
						switch ($commentcount){
							case 0 :echo "1<span class='dot'>楼</span>";++$commentcount;break;
							case 1 :echo "2<span class='dot'>楼</span>";++$commentcount;break;
							case 2 :echo "3<span class='dot'>楼</span>";++$commentcount;break;
							default:printf('%1$s<span class="dot">楼</span>', ++$commentcount);
						}
					}
				?>
				<?php if( $depth > 1){printf('地下%1$s层', $depth-1);} ?></a>
</span><?php printf(__('<cite class="fn">%s</cite>'), get_comment_author_link()) ?><div id="reply"><?php comment_reply_link(array_merge( $args, array('reply_text' => '回复该留言','depth' => $depth, 'max_depth' => $args['max_depth']))) ?></div></div>
                    <div id="empost">Post:<?php printf(__('%1$s at %2$s'), get_comment_date('Y/m/d '),  get_comment_time(' H:i:s')) ?></div>
          </div>
		  <?php if ($comment->comment_approved == '0') : ?>
             <em><?php _e('您的评论正在等待审核！') ?></em>
             <br />
          <?php endif; ?>
      		<?php comment_text() ?>
     </div>
	<?php
}
endif;

/// 函数作用：取得文章的阅读次数
function record_visitors()
{
	if (is_singular()) 
	{
	  global $post;
	  $post_ID = $post->ID;
	  if($post_ID) 
	  {
		  $post_views = (int)get_post_meta($post_ID, 'views', true);
		  if(!update_post_meta($post_ID, 'views', ($post_views+1))) 
		  {
			add_post_meta($post_ID, 'views', 1, true);
		  }
	  }
	}
}
add_action('wp_head', 'record_visitors');  
/// 函数名称：post_views 
/// 函数作用：取得文章的阅读次数
function post_views($before = '(点击 ', $after = ' 次)', $echo = 1)
{
  global $post;
  $post_ID = $post->ID;
  $views = (int)get_post_meta($post_ID, 'views', true);
  if ($echo) echo $before, number_format($views), $after;
  else return $views;
}

// 获得热评文章
function zhang_get_most_viewed($posts_num=10, $days=120){
    global $wpdb;
    $sql = "SELECT ID , post_title , comment_count FROM $wpdb->posts WHERE post_type = 'post' AND TO_DAYS(now()) - TO_DAYS(post_date) < $days AND ($wpdb->posts.`post_status` = 'publish' OR $wpdb->posts.`post_status` = 'inherit') ORDER BY comment_count DESC LIMIT 0 , $posts_num ";
    $posts = $wpdb->get_results($sql);
    $output = "";
    foreach ($posts as $post){
        $output .= "\n<li><a href= \"".get_permalink($post->ID)."\" target=\"_blank\" title=\"".$post->post_title."\" >".$post->post_title."</a></li>";
    }
    echo $output;
}

/*总浏览数*/
function lo_all_view(){global $wpdb;$count=0;$views= $wpdb->get_results("SELECT * FROM $wpdb->postmeta WHERE meta_key='views'");foreach($views as $key=>$value){$meta_value=$value->meta_value;if($meta_value!=' '){$count+=(int)$meta_value;}}return $count;}

//分页
function pagination($query_string){
global $posts_per_page, $paged;
$my_query = new WP_Query($query_string ."&posts_per_page=-1");
$total_posts = $my_query->post_count;
if(empty($paged))$paged = 1;
$prev = $paged - 1;							
$next = $paged + 1;	
$range = 4; // 分页数设置
$showitems = ($range * 2)+1;
$pages = ceil($total_posts/$posts_per_page);
if(1 != $pages){
	echo "<div class='pagination'>";
	echo ($paged > 2 && $paged+$range+1 > $pages && $showitems < $pages)? "<a href='".get_pagenum_link(1)."' class='fir_las'>最前</a>":"";
	echo ($paged > 1 && $showitems < $pages)? "<a href='".get_pagenum_link($prev)."' class='page_previous'>« 上一页</a>":"";		
	for ($i=1; $i <= $pages; $i++){
	if (1 != $pages &&( !($i >= $paged+$range+1 || $i <= $paged-$range-1) || $pages <= $showitems )){
	echo ($paged == $i)? "<span class='current'>".$i."</span>":"<a href='".get_pagenum_link($i)."' class='inactive' >".$i."</a>"; 
	}
	}
	echo ($paged < $pages && $showitems < $pages) ? "<a href='".get_pagenum_link($next)."' class='page_next'>下一页 »</a>" :"";
	echo ($paged < $pages-1 &&  $paged+$range-1 < $pages && $showitems < $pages) ? "<a href='".get_pagenum_link($pages)."' class='fir_las'>最后</a>":"";
	echo "</div>\n";
	}
}

//缓存avatar
function mytheme_get_avatar($avatar) {
$avatar = str_replace(array("www.gravatar.com","0.gravatar.com","1.gravatar.com","2.gravatar.com"),"gravatar.duoshuo.com",$avatar);
return $avatar;
}
add_filter( 'get_avatar', 'mytheme_get_avatar', 10, 3 );

//最新评论函数   
function r_comments($outer){
	global $wpdb;
	$sql = "SELECT DISTINCT ID, post_title, post_password, comment_ID, comment_post_ID, comment_author, comment_date_gmt, comment_approved, comment_type,comment_author_url,comment_author_email, SUBSTRING(comment_content,1,14) AS com_excerpt FROM $wpdb->comments LEFT OUTER JOIN $wpdb->posts ON ($wpdb->comments.comment_post_ID = $wpdb->posts.ID) WHERE comment_approved = '1' AND comment_type = '' AND post_password = '' AND user_id='0' AND comment_author != '".$outer."' ORDER BY comment_date_gmt DESC LIMIT 10";
	$comments = $wpdb->get_results($sql);
	$output = $pre_HTML;
	foreach ($comments as $comment) {
	$output .= "\n<li><a rel=\"nofollow\" href=\"" . get_permalink($comment->ID) . "#comment-" . $comment->comment_ID . "\" title=\"". $comment->comment_author. "在 " . $comment->post_title . " 上的评论\">" . strip_tags($comment->com_excerpt) ."</a></li>";}
	$output .= $post_HTML;
echo $output;
};

//新窗口打开评论里的链接
function remove_comment_links() {
global $comment;
$url = get_comment_author_url();
$author = get_comment_author();
if ( empty( $url ) || 'http://' == $url )
$return = $author;
else
$return = "<a href='$url' rel='external nofollow' target='_blank'>$author</a>";
return $return;
}
add_filter('get_comment_author_link', 'remove_comment_links');
remove_filter('comment_text', 'make_clickable', 9);

//谷歌字体移除
function remove_open_sans() {
wp_deregister_style( 'open-sans' );
wp_register_style( 'open-sans', false );
wp_enqueue_style('open-sans','');
}
add_action( 'init', 'remove_open_sans' );

//增强在线编辑器
function dopt($e){
    return stripslashes(get_option($e));
}

//阻止站内文章Pingback 
function deel_noself_ping( &$links ) {
  $home = get_option( 'home' );
  foreach ( $links as $l => $link )
  if ( 0 === strpos( $link, $home ) )
  unset($links[$l]);
}

//移除WordPress版本号
function wpbeginner_remove_version() {
return '';
}
add_filter('the_generator', 'wpbeginner_remove_version');

// 评论回应邮件通知
function comment_mail_notify($comment_id) {
  $admin_email = get_bloginfo ('admin_email'); // $admin_email 可改指定的 e-mail.
  $comment = get_comment($comment_id);
  $comment_author_email = trim($comment->comment_author_email);
  $parent_id = $comment->comment_parent ? $comment->comment_parent : '';
  $to = $parent_id ? trim(get_comment($parent_id)->comment_author_email) : '';
  $spam_confirmed = $comment->comment_approved;
  if (($parent_id != '') && ($spam_confirmed != 'spam') && ($to != $admin_email) && ($comment_author_email == $admin_email)) {
    /* 上面的判断式,决定发出邮件的必要条件:
    ($parent_id != '') && ($spam_confirmed != 'spam'): 回复的, 而且不是 spam 才可发, 必需!!
    ($to != $admin_email) : 不发给 admin.
    ($comment_author_email == $admin_email) : 只有 admin 的回复才可发.
    可视个人需求修改以上条件.
    */
    $wp_email = 'no-reply@' . preg_replace('#^www\.#', '', strtolower($_SERVER['SERVER_NAME'])); // e-mail 发出点, no-reply 可改为可用的 e-mail.
    $subject = '您在 [' . get_option("blogname") . '] 的留言有了回应';
    $message = '
    <div style="padding: 15px; font-family: arial, sans-serif;">
      <p style="color: #000; font-weight: bold; background: #F5F5F5; padding: 10px; border: 1px solid #e0e0e0;">' . trim(get_comment($parent_id)->comment_author) . ', 您好!</p>
      <p>您曾在《' . get_the_title($comment->comment_post_ID) . '》的留言:<br /></p>
       <p style="background: #fff; border: 1px solid #e0e0e0; color: #000;  line-height: 180%; padding: 10px; text-indent: 2em;">' . trim(get_comment($parent_id)->comment_content) . '</p>
        <p>' . trim($comment->comment_author) . ' 给您的回应:<br /></p>
       <p style="background: #fff; border:1px solid #e0e0e0; color: #000; line-height: 180%; padding: 10px; text-indent: 2em;">' . trim($comment->comment_content) . '<br /></p>
      <p style="background: #f2f2f2; border: 1px solid #e0e0e0; padding: 10px;">您可以点击 <a href="' . htmlspecialchars(get_comment_link($parent_id)) . '">查看回应完整內容</a></p>
      <p style="text-align: center;">欢迎您再度光临 <a href="' . get_option('home') . '">' . get_option('blogname') . '</a></p>
      <p style="color: #ff0000; font-weight: bold;text-align: center;">此邮件由系统自动发出，请勿回复.</p>
    </div>';
    $from = "From: \"" . get_option('blogname') . "\" <$wp_email>";
    $headers = "$from\nContent-Type: text/html; charset=" . get_option('blog_charset') . "\n";
    wp_mail( $to, $subject, $message, $headers );
    //echo 'mail to ', $to, '<br/> ' , $subject, $message; // for testing
  }
}
add_action('comment_post', 'comment_mail_notify');

?>
