<?php
class bigfa_widget extends WP_Widget {
    function bigfa_widget() {
        $widget_ops = array('description' => '以标题的形式列出一个月内评论最多的文章');
        $this->WP_Widget('popular_posts', '热门文章', $widget_ops);
    }
    function widget($args, $instance) {
        extract($args);
        $title = apply_filters('widget_title',esc_attr($instance['title']));
        $limit = strip_tags($instance['limit']) ? strip_tags($instance['limit']) : 5;
        $limits = strip_tags($instance['limits']);
        ?>
        <div class="block" id="a<?php echo $limits;?>"><?php echo $before_title.''.$title.$after_title ?>
        <ul class="modified-posts JS-is-pjax">
            <?php query_posts( array('date_query' => array(
                array(
                    'after'  => '1 month ago',
                ),
            ),'showposts' => $limit,'orderby' => 'comment_count','ignore_sticky_posts' => 1));?>
            <?php $numbers = range (1,15);shuffle($numbers);$result = array_slice($numbers,1,$limit);$i=0;while (have_posts()) : the_post(); ?>
                <li><a href="<?php the_permalink() ?>" rel="bookmark" title="<?php the_title(); ?>"><?php the_title(); ?></a></li>
                <?php $i++;endwhile;wp_reset_query(); ?>
        </ul>

        <?php
        echo $after_widget;
    }

    function update($new_instance, $old_instance) {
        if (!isset($new_instance['submit'])) {
            return false;
        }
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['limit'] = strip_tags($new_instance['limit']);
        $instance['limits'] = strip_tags($new_instance['limits']);
        return $instance;
    }
    function form($instance) {
        global $wpdb;
        $instance = wp_parse_args((array) $instance, array('title' => '', 'limit' => ''));
        $title = esc_attr($instance['title']);
        $limit = strip_tags($instance['limit']);
        $limits = strip_tags($instance['limits']);
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">标题：<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('limit'); ?>">文章数量：<input class="widefat" id="<?php echo $this->get_field_id('limit'); ?>" name="<?php echo $this->get_field_name('limit'); ?>" type="text" value="<?php echo $limit; ?>" /></label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('limits'); ?>">填写滑动数字：one、two、three、four、five,留空则不滑动！<input class="widefat" id="<?php echo $this->get_field_id('limits'); ?>" name="<?php echo $this->get_field_name('limits'); ?>" type="text" value="<?php echo $limits; ?>" /></label>
        </p>
        <input type="hidden" id="<?php echo $this->get_field_id('submit'); ?>" name="<?php echo $this->get_field_name('submit'); ?>" value="1" />
    <?php
    }
}
add_action('widgets_init', 'bigfa_widget_init');
function bigfa_widget_init() {
    register_widget('bigfa_widget');
}

class  bigfa_widget2 extends WP_Widget {
    function bigfa_widget2() {
        $widget_ops = array('description' => '站内搜索');
        $this->WP_Widget('search', '站内搜索', $widget_ops);
    }
    function widget($args, $instance) {
        extract($args);
		$title = apply_filters('title',esc_attr($instance['title']));
		$limits = strip_tags($instance['limits']);
        ?><div class="block" id="a<?php echo $limits;?>"><?php echo $before_title.''.$title.$after_title ?>
    <div class="textwidget">
	    <form id="searchform" method="get" action="<?php bloginfo('home'); ?>">
		    <input type="text" value="<?php the_search_query(); ?>" name="s" id="s" size="30" placeholder="请输入关键词" x-webkit-speech />
			<button type="submit" id="searchsubmit">搜 索</button>
		</form>
    </div>
        <?php
        echo $after_widget;
    }
    function update($new_instance, $old_instance) {
        if (!isset($new_instance['submit'])) {
            return false;
        }
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
		$instance['limits'] = strip_tags($new_instance['limits']);
        return $instance;
    }
    function form($instance) {
        global $wpdb;
        $instance = wp_parse_args((array) $instance, array('title' => '', 'limit' => ''));
        $title = esc_attr($instance['title']);
		$limits = strip_tags($instance['limits']);
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">标题：<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('limits'); ?>">填写滑动数字：one、two、three、four、five,留空则不滑动！<input class="widefat" id="<?php echo $this->get_field_id('limits'); ?>" name="<?php echo $this->get_field_name('limits'); ?>" type="text" value="<?php echo $limits; ?>" /></label>
        </p>
        <input type="hidden" id="<?php echo $this->get_field_id('submit'); ?>" name="<?php echo $this->get_field_name('submit'); ?>" value="1" />
    <?php
    }
}
add_action('widgets_init', 'bigfa_widget2_init');
function bigfa_widget2_init() {
    register_widget('bigfa_widget2');
}

class bigfa_widget3 extends WP_Widget {
    function bigfa_widget3() {
        $widget_ops = array('description' => '列出站点最近的评论');
        $this->WP_Widget('rencent_comments', '最新评论', $widget_ops);
    }
    function widget($args, $instance) {
        extract($args);
        $title = apply_filters('widget_title',esc_attr($instance['title']));
        $limit = strip_tags($instance['limit']) ? strip_tags($instance['limit']) : 5;
	$limits = strip_tags($instance['limits']);
        ?>
        <div class="block" id="a<?php echo $limits;?>"><?php echo $before_title.''.$title.$after_title ?>
        <ul class="comment">
            <?php
            global $wpdb;
            $limit_num = $limit;
            $rc_comms = $wpdb->get_results("SELECT ID, post_title, comment_ID, comment_author,comment_author_email,comment_date,comment_content FROM $wpdb->comments LEFT OUTER JOIN $wpdb->posts ON ($wpdb->comments.comment_post_ID  = $wpdb->posts.ID) WHERE comment_approved = '1' AND comment_type = '' AND post_password = '' AND user_id='0' AND comment_author != '".$outer."' ORDER BY comment_date_gmt DESC LIMIT $limit_num ");
            $rc_comments = '';
            foreach ($rc_comms as $rc_comm) { $rc_comments .= "<li><a href='". get_comment_link($rc_comm->comment_ID) . "' title='".$rc_comm->comment_author."在 " . $rc_comm->post_title .  " 发表的评论'>". $rc_comm->comment_content."</a></li>\n";}
            echo $rc_comments;
            ?>
        </ul>

        <?php
        echo $after_widget;
    }
    function update($new_instance, $old_instance) {
        if (!isset($new_instance['submit'])) {
            return false;
        }
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['limit'] = strip_tags($new_instance['limit']);
		$instance['limits'] = strip_tags($new_instance['limits']);
        return $instance;
    }
    function form($instance) {
        global $wpdb;
        $instance = wp_parse_args((array) $instance, array('title'=> '', 'limit' => '', 'email' => ''));
        $title = esc_attr($instance['title']);
        $limit = strip_tags($instance['limit']);
		$limits = strip_tags($instance['limits']);
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">标题：<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('limit'); ?>">显示数量：(最好5个以下) <input class="widefat" id="<?php echo $this->get_field_id('limit'); ?>" name="<?php echo $this->get_field_name('limit'); ?>" type="text" value="<?php echo $limit; ?>" /></label>
        </p>
                <p>
            <label for="<?php echo $this->get_field_id('limits'); ?>">填写滑动数字：one、two、three、four、five,留空则不滑动！<input class="widefat" id="<?php echo $this->get_field_id('limits'); ?>" name="<?php echo $this->get_field_name('limits'); ?>" type="text" value="<?php echo $limits; ?>" /></label>
        </p>
        <input type="hidden" id="<?php echo $this->get_field_id('submit'); ?>" name="<?php echo $this->get_field_name('submit'); ?>" value="1" />
    <?php
    }
}
add_action('widgets_init', 'bigfa_widget3_init');
function bigfa_widget3_init() {
    register_widget('bigfa_widget3');
}

class bigfa_widget6 extends WP_Widget {
    function bigfa_widget6() {
        $widget_ops = array('description' => '配合主题样式，字体大小统一');
        $this->WP_Widget('popular_tags', '标签云', $widget_ops);
    }
    function widget($args, $instance) {
        extract($args);
        $title = apply_filters('widget_title',esc_attr($instance['title']));
        $limit = strip_tags($instance['limit']);
		$limits = strip_tags($instance['limits']);
        ?>
        <div class="block" id="a<?php echo $limits;?>"><?php echo $before_title.''.$title.$after_title ?>
        <div class="seo_tag">
            <?php
            wp_tag_cloud( array(
                    'unit' => 'px',
                    'smallest' => 13,
                    'largest' => 13,
                    'number' => $limit,
                    'format' => 'flat',
                    'orderby' => 'count',
                    'order' => 'DESC'
                )
            );
            ?>
        </div>

        <?php
        echo $after_widget;
    }
    function update($new_instance, $old_instance) {
        if (!isset($new_instance['submit'])) {
            return false;
        }
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['limit'] = strip_tags($new_instance['limit']);
		$instance['limits'] = strip_tags($new_instance['limits']);
        return $instance;
    }
    function form($instance) {
        global $wpdb;
        $instance = wp_parse_args((array) $instance, array('title'=> '', 'limit' => ''));
        $title = esc_attr($instance['title']);
        $limit = strip_tags($instance['limit']);
		$limits = strip_tags($instance['limits']);
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">标题：<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('limit'); ?>">显示数量：<input class="widefat" id="<?php echo $this->get_field_id('limit'); ?>" name="<?php echo $this->get_field_name('limit'); ?>" type="text" value="<?php echo $limit; ?>" /></label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('limits'); ?>">填写滑动数字：one、two、three、four、five,留空则不滑动！<input class="widefat" id="<?php echo $this->get_field_id('limits'); ?>" name="<?php echo $this->get_field_name('limits'); ?>" type="text" value="<?php echo $limits; ?>" /></label>
        </p>
        <input type="hidden" id="<?php echo $this->get_field_id('submit'); ?>" name="<?php echo $this->get_field_name('submit'); ?>" value="1" />
    <?php
    }
}
add_action('widgets_init', 'bigfa_widget6_init');
function bigfa_widget6_init() {
    register_widget('bigfa_widget6');
}

class bigfa_widget7 extends WP_Widget {
    function bigfa_widget7() {
        $widget_ops = array('description' => '双栏的分类目录，只支持一级目录');
        $this->WP_Widget('post_categories', '分类目录', $widget_ops);
    }
    function widget($args, $instance) {
        extract($args);
        $title = apply_filters('widget_title',esc_attr($instance['title']));
	$limits = strip_tags($instance['limits']);
        ?>
        <div class="blocks" id="a<?php echo $limits;?>"><?php echo $before_title.''.$title.$after_title ?>
        <ul class="menunav">
            <?php wp_list_categories( array(
                    'style' => 'list',
                    'show_count' => 0,
                    'title_li' => '',
                    'order' => 'ASC',
                    'echo' => 1
                )
            );
            ?>
        </ul>

        <?php
        echo $after_widget;
    }
    function update($new_instance, $old_instance) {
        if (!isset($new_instance['submit'])) {
            return false;
        }
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
	$instance['limits'] = strip_tags($new_instance['limits']);
        return $instance;
    }
    function form($instance) {
        global $wpdb;
        $instance = wp_parse_args((array) $instance, array('title'=> ''));
        $title = esc_attr($instance['title']);
	$limits = strip_tags($instance['limits']);
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">标题：<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('limits'); ?>">填写滑动数字：one、two、three、four、five,留空则不滑动！<input class="widefat" id="<?php echo $this->get_field_id('limits'); ?>" name="<?php echo $this->get_field_name('limits'); ?>" type="text" value="<?php echo $limits; ?>" /></label>
        </p>
        <input type="hidden" id="<?php echo $this->get_field_id('submit'); ?>" name="<?php echo $this->get_field_name('submit'); ?>" value="1" />
    <?php
    }
}
add_action('widgets_init', 'bigfa_widget7_init');
function bigfa_widget7_init() {
    register_widget('bigfa_widget7');
}

class bigfa_widget8 extends WP_Widget {
    function bigfa_widget8() {
        $widget_ops = array('description' => '自带邮箱订阅列表，如果有请输入订阅ID即可！');
        $this->WP_Widget('qq_list', '邮箱订阅', $widget_ops);
    }
    function widget($args, $instance) {
        extract($args);
		$limit = strip_tags($instance['limit']);
        $limits = strip_tags($instance['limits']);
        ?>
        <div class="textwidget" id="a<?php echo $limits;?>">
        <div class="rssbook">
<div class="mailInput">填写您的邮箱，订阅我的精彩文章：
<form action="http://list.qq.com/cgi-bin/qf_compose_send" target='_blank' method='post'>
<input type="hidden" name="t" value="qf_booked_feedback">
<input type="hidden" name="id" value="<?php echo $limit;?>">
<input  id="to" name="to" type="text" class="rsstxt" value=""/>
<input class="rssbutton" type="submit" value="订   阅">
</form></div></div>
        <?php
        echo $after_widget;
    }
    function update($new_instance, $old_instance) {
        if (!isset($new_instance['submit'])) {
            return false;
        }
        $instance = $old_instance;
		$instance['limit'] = strip_tags($new_instance['limit']);
		$instance['limits'] = strip_tags($new_instance['limits']);
        return $instance;
    }
    function form($instance) {
        global $wpdb;
		$limit = strip_tags($instance['limit']);
		$limits = strip_tags($instance['limits']);
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('limit'); ?>">邮箱订阅ID号：<input class="widefat" id="<?php echo $this->get_field_id('limit'); ?>" name="<?php echo $this->get_field_name('limit'); ?>" type="text" value="<?php echo $limit; ?>" /></label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('limits'); ?>">填写滑动数字：one、two、three、four、five,留空则不滑动！<input class="widefat" id="<?php echo $this->get_field_id('limits'); ?>" name="<?php echo $this->get_field_name('limits'); ?>" type="text" value="<?php echo $limits; ?>" /></label>
        </p>
        <input type="hidden" id="<?php echo $this->get_field_id('submit'); ?>" name="<?php echo $this->get_field_name('submit'); ?>" value="1" />
    <?php
    }
}
add_action('widgets_init', 'bigfa_widget8_init');
function bigfa_widget8_init() {
    register_widget('bigfa_widget8');
}

class bigfa_widget9 extends WP_Widget {
    function bigfa_widget9() {
        $widget_ops = array('description' => '主题自带下拉式的文章归档小工具');
        $this->WP_Widget('archives_list', '文章归档', $widget_ops);
    }
    function widget($args, $instance) {
        extract($args);
        $title = apply_filters('widget_title',esc_attr($instance['title']));
        $limits = strip_tags($instance['limits']);
        ?>
        <div class="block" id="a<?php echo $limits;?>"><?php echo $before_title.''.$title.$after_title ?>
        <div class="seo_tag">
<select name="archive-dropdown" onChange='document.location.href=this.options[this.selectedIndex].value;'> 
  <option value=""><?php echo attribute_escape(__('Select Month')); ?></option> 
  <?php wp_get_archives('type=monthly&format=option&show_post_count=1'); ?> </select></div>
        <?php
        echo $after_widget;
    }
    function update($new_instance, $old_instance) {
        if (!isset($new_instance['submit'])) {
            return false;
        }
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
		$instance['limits'] = strip_tags($new_instance['limits']);
        return $instance;
    }
    function form($instance) {
        global $wpdb;
		$title = esc_attr($instance['title']);
		$limits = strip_tags($instance['limits']);
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">标题：<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('limits'); ?>">填写滑动数字：one、two、three、four、five,留空则不滑动！<input class="widefat" id="<?php echo $this->get_field_id('limits'); ?>" name="<?php echo $this->get_field_name('limits'); ?>" type="text" value="<?php echo $limits; ?>" /></label>
        </p>
        <input type="hidden" id="<?php echo $this->get_field_id('submit'); ?>" name="<?php echo $this->get_field_name('submit'); ?>" value="1" />
    <?php
    }
}
add_action('widgets_init', 'bigfa_widget9_init');
function bigfa_widget9_init() {
    register_widget('bigfa_widget9');
}

class bigfa_widget10 extends WP_Widget {
    function bigfa_widget10() {
        $widget_ops = array('description' => '以标题排行的形式列出浏览阅读最多的文章');
        $this->WP_Widget('vivew_posts', '浏览排行', $widget_ops);
    }
    function widget($args, $instance) {
        extract($args);
        $title = apply_filters('widget_title',esc_attr($instance['title']));
        $strtotime = strip_tags($instance['strtotime']);
		$limit = strip_tags($instance['date']);
        $limits = strip_tags($instance['limits']);
        ?>
        <div class="block" id="a<?php echo $limits;?>"><?php echo $before_title.''.$title.$after_title ?>
        <ul>
<?php
global $wpdb, $post;
$output = '';
$most_viewed = $wpdb->get_results("SELECT DISTINCT $wpdb->posts.*, (meta_value+0) AS views FROM $wpdb->posts LEFT JOIN $wpdb->postmeta ON $wpdb->postmeta.post_id = $wpdb->posts.ID WHERE post_date > '".date('Y-m-d',strtotime('-'.$strtotime.'days'))."' AND post_type ='post' AND post_status = 'publish' AND meta_key = 'views' AND post_password = '' ORDER BY views DESC LIMIT $limit");//设置近100天内文章的排行榜
if($most_viewed) {
foreach ($most_viewed as $post) {
$output .= "\n<li><a href= \"".get_permalink($post->ID)."\" rel=\"bookmark\" title=\"".$post->post_title." (".$post->views."+)\" >". $post->post_title."</a></li>";
}
echo $output;
}; ?>
        </ul>

        <?php
        echo $after_widget;
    }

    function update($new_instance, $old_instance) {
        if (!isset($new_instance['submit'])) {
            return false;
        }
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['strtotime'] = strip_tags($new_instance['strtotime']);
		$instance['date'] = strip_tags($new_instance['date']);
		$instance['limits'] = strip_tags($new_instance['limits']);
        return $instance;
    }
    function form($instance) {
        global $wpdb;
        $instance = wp_parse_args((array) $instance, array('title' => '', 'limit' => ''));
        $title = esc_attr($instance['title']);
        $strtotime = strip_tags($instance['strtotime']);
		$date = strip_tags($instance['date']);
		$limits = strip_tags($instance['limits']);
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">标题：<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></label>
        </p>
       <p>
            <label for="<?php echo $this->get_field_id('strtotime'); ?>">统计时间：一周填7，一月填30，一季度填90<input class="widefat" id="<?php echo $this->get_field_id('strtotime'); ?>" name="<?php echo $this->get_field_name('strtotime'); ?>" type="text" value="<?php echo $strtotime; ?>" /></label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('date'); ?>">文章数量：<input class="widefat" id="<?php echo $this->get_field_id('date'); ?>" name="<?php echo $this->get_field_name('date'); ?>" type="text" value="<?php echo $date; ?>" /></label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('limits'); ?>">填写滑动数字：one、two、three、four、five,留空则不滑动！<input class="widefat" id="<?php echo $this->get_field_id('limits'); ?>" name="<?php echo $this->get_field_name('limits'); ?>" type="text" value="<?php echo $limits; ?>" /></label>
        </p>
        <input type="hidden" id="<?php echo $this->get_field_id('submit'); ?>" name="<?php echo $this->get_field_name('submit'); ?>" value="1" />
    <?php
    }
}
add_action('widgets_init', 'bigfa_widget10_init');
function bigfa_widget10_init() {
    register_widget('bigfa_widget10');
}

class  bigfa_widget11 extends WP_Widget {
    function bigfa_widget11() {
        $widget_ops = array('description' => '双栏的友情链接，只支持一级目录');
        $this->WP_Widget('friend_links', '友情链接', $widget_ops);
    }
    function widget($args, $instance) {
        extract($args);
        $title = apply_filters('widget_title',esc_attr($instance['title']));
        $limit = strip_tags($instance['limit']);
        $orderby = strip_tags($instance['orderby']);
        $cats = strip_tags($instance['cats']);
        echo $before_widget.$before_title.$title.$after_title;
        ?>
        <ul class="block links">
            <?php wp_list_bookmarks( array(
                    'limit' => $limit,
                    'hide_empty' => 1,
                    'category'  => $cats,
                    'categorize' => 0,
                    'title_li' => '',
                    'orderby' => $orderby,
                    'order' => 'ASC',
                    'echo' => 1
                )
            );
            ?>
        </ul>

        <?php
        echo $after_widget;
    }
    function update($new_instance, $old_instance) {
        if (!isset($new_instance['submit'])) {
            return false;
        }
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['limit'] = strip_tags($new_instance['limit']);
        $instance['orderby'] = strip_tags($new_instance['orderby']);
        $instance['cats'] = strip_tags($new_instance['cats']);
        return $instance;
    }
    function form($instance) {
        global $wpdb;
        $instance = wp_parse_args((array) $instance, array('title'=> '', 'limit' => '-1', 'cats' => '', 'orderby' => 'name'));
        $title = esc_attr($instance['title']);
        $limit = strip_tags($instance['limit']);
        $orderby = strip_tags($instance['orderby']);
        $cats = strip_tags($instance['cats']);
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">标题：<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('limit'); ?>">数量：默认"-1"为全部显示。<br>如果需要限时数量，输入具体数值<input class="widefat" id="<?php echo $this->get_field_id('limit'); ?>" name="<?php echo $this->get_field_name('limit'); ?>" type="text" value="<?php echo $limit; ?>" /></label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('cats'); ?>">显示分类：<br>● 默认不填写即显示所有分类里的链接<br>● 填写某分类的ID，显示此分类下的链接<input class="widefat" id="<?php echo $this->get_field_id('cats'); ?>" name="<?php echo $this->get_field_name('cats'); ?>" type="text" value="<?php echo $cats; ?>" /></label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('orderby'); ?>">排序：<br>● 默认"name"按名称排列<br>● 如果需要其他排列，输入相应的排序形式。<a target="_blank" href="http://codex.wordpress.org/Function_Reference/wp_list_bookmarks">查看orderby排序参数</a><input class="widefat" id="<?php echo $this->get_field_id('orderby'); ?>" name="<?php echo $this->get_field_name('orderby'); ?>" type="text" value="<?php echo $orderby; ?>" /></label>
        </p>
        <input type="hidden" id="<?php echo $this->get_field_id('submit'); ?>" name="<?php echo $this->get_field_name('submit'); ?>" value="1" />
    <?php
    }
}
add_action('widgets_init', 'bigfa_widget11_init');
function bigfa_widget11_init() {
    register_widget('bigfa_widget11');
}

class  bigfa_widget13 extends WP_Widget {
    function bigfa_widget13() {
        $widget_ops = array('description' => '站点的一些基本信息');
        $this->WP_Widget('website_anylists', '网站统计', $widget_ops);
    }
    function widget($args, $instance) {
        extract($args);
        $title = apply_filters('widget_title',esc_attr($instance['title']));
		$limits = strip_tags($instance['limits']);
        ?>
        <div class="block" id="a<?php echo $limits;?>"><?php echo $before_title.''.$title.$after_title ?>
        <ul class="website-anylists">
            <li>文章总数：<?php $count_posts = wp_count_posts();echo $published_posts = $count_posts->publish;?>篇</li>
            <li>评论总数：<?php $count_comments = get_comment_count();echo $count_comments['approved'];?>条</li>
            <li>浏览总数：<?php echo lo_all_view(); ?>次</li>
            <li>当前主题：灿灿主题</li>
        </ul>

        <?php
        echo $after_widget;
    }
    function update($new_instance, $old_instance) {
        if (!isset($new_instance['submit'])) {
            return false;
        }
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
		$instance['limits'] = strip_tags($new_instance['limits']);
        return $instance;
    }
    function form($instance) {
        global $wpdb;
        $instance = wp_parse_args((array) $instance, array('title'=> ''));
        $title = esc_attr($instance['title']);
		$limits = strip_tags($instance['limits']);
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">标题：<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('limits'); ?>">填写滑动数字：one、two、three、four、five,留空则不滑动！<input class="widefat" id="<?php echo $this->get_field_id('limits'); ?>" name="<?php echo $this->get_field_name('limits'); ?>" type="text" value="<?php echo $limits; ?>" /></label>
        </p>
        <input type="hidden" id="<?php echo $this->get_field_id('submit'); ?>" name="<?php echo $this->get_field_name('submit'); ?>" value="1" />
    <?php
    }
}
add_action('widgets_init', 'bigfa_widget13_init');
function bigfa_widget13_init() {
    register_widget('bigfa_widget13');
}

class bigfa_widget15 extends WP_Widget {
    function bigfa_widget15() {
        $widget_ops = array('description' => '侧边图片广告，图片尺寸为300*250');
        $this->WP_Widget('adbox', '图片广告', $widget_ops);
    }
    function widget($args, $instance) {
        extract($args);
        $title = apply_filters('widget_title',esc_attr($instance['title']));
		$pic = strip_tags($instance['pic']);
        $limit = strip_tags($instance['limit']);
		$limits = strip_tags($instance['limits']);
		echo $before_widget;
		if ( ! empty( $title ) )
		echo $before_title.'' . $title . $after_title;
        ?>
        <div class="textwidget" id="a<?php echo $limits;?>">
            <a href="<?php echo $limit; ?>" target="_blank" rel="nofollow"><img alt="<?php echo $title;?>" src="<?php echo $pic; ?>" width="300px" height="250px"/></a></div>

        <?php
        echo $after_widget;
    }
    function update($new_instance, $old_instance) {
        if (!isset($new_instance['submit'])) {
            return false;
        }
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
		$instance['pic'] = strip_tags($new_instance['pic']);
        $instance['limit'] = strip_tags($new_instance['limit']);
        $instance['limits'] = strip_tags($new_instance['limits']);
        return $instance;
    }
    function form($instance) {
        global $wpdb;
        $instance = wp_parse_args((array) $instance, array('title'=> '', 'limit' => ''));
        $title = esc_attr($instance['title']);
		$pic = strip_tags($instance['pic']);
        $limit = strip_tags($instance['limit']);
		$limits = strip_tags($instance['limits']);
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">标题：<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></label>
        </p>
                <p>
            <label for="<?php echo $this->get_field_id('pic'); ?>">图片地址：<input class="widefat" id="<?php echo $this->get_field_id('pic'); ?>" name="<?php echo $this->get_field_name('pic'); ?>" type="text" value="<?php echo $pic; ?>" /></label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('limit'); ?>">广告链接：<input class="widefat" id="<?php echo $this->get_field_id('limit'); ?>" name="<?php echo $this->get_field_name('limit'); ?>" type="text" value="<?php echo $limit; ?>" /></label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('limits'); ?>">填写滑动数字：one、two、three、four、five,留空则不滑动！<input class="widefat" id="<?php echo $this->get_field_id('limits'); ?>" name="<?php echo $this->get_field_name('limits'); ?>" type="text" value="<?php echo $limits; ?>" /></label>
        </p>
        <input type="hidden" id="<?php echo $this->get_field_id('submit'); ?>" name="<?php echo $this->get_field_name('submit'); ?>" value="1" />
    <?php
    }
}
add_action('widgets_init', 'bigfa_widget15_init');
function bigfa_widget15_init() {
    register_widget('bigfa_widget15');
}

class bigfa_widget17 extends WP_Widget {
    function bigfa_widget17() {
        $widget_ops = array('description' => '主题自带文本小工具，支持HTML！');
        $this->WP_Widget('mp_banner', '文本工具', $widget_ops);
    }
    function widget($args, $instance) {
        extract($args);
        $title = apply_filters('widget_title',esc_attr($instance['title']));
        $code=$instance['code'];
		$limits = strip_tags($instance['limits']);
		echo $before_widget;
		if ( ! empty( $title ) )
		echo $before_title .''. $title . $after_title;
        ?>
        <div class="textwidget" id="a<?php echo $limits;?>"><?php echo stripslashes($code); ?></div>

        <?php
        echo $after_widget;
    }
    function update($new_instance, $old_instance) {
        if (!isset($new_instance['submit'])) {
            return false;
        }
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['limits'] = strip_tags($new_instance['limits']);
        $instance['code']=$new_instance['code'];
        return $instance;
    }
    function form($instance) {
        global $wpdb;
        $instance = wp_parse_args((array) $instance, array('title'=> '', 'limit' => ''));
        $title = esc_attr($instance['title']);
        $limits = strip_tags($instance['limits']);
		$code=$instance['code'];
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">标题：<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('limit'); ?>">输入内容：<textarea id="<?php echo $this->get_field_id('code');?>" name="<?php echo $this->get_field_name('code');?>" class="widefat" rows="10" style="font-family:Courier New;"><?php echo attribute_escape($code);?></textarea></label>
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('limits'); ?>">填写滑动数字：one、two、three、four、five,留空则不滑动！<input class="widefat" id="<?php echo $this->get_field_id('limits'); ?>" name="<?php echo $this->get_field_name('limits'); ?>" type="text" value="<?php echo $limits; ?>" /></label>
        </p>
        <input type="hidden" id="<?php echo $this->get_field_id('submit'); ?>" name="<?php echo $this->get_field_name('submit'); ?>" value="1" />
    <?php
    }
}
add_action('widgets_init', 'bigfa_widget17_init');
function bigfa_widget17_init() {
    register_widget('bigfa_widget17');
}

function d_postlists() {
	register_widget( 'd_postlist' );
}

class d_postlist extends WP_Widget {
	function d_postlist() {
		$widget_ops = array( 'classname' => 'd_postlist', 'description' => '最新文章+热门文章+随机文章' );
		$this->WP_Widget( 'd_postlist', '聚合文章', $widget_ops, $control_ops );
	}

	function widget( $args, $instance ) {
		extract( $args );
		$title        = apply_filters('widget_name', $instance['title']);
		$limit        = $instance['limit'];
		$limits       = $instance['limits'];
		$orderby      = $instance['orderby'];
		echo '<div class="block" id="a'.$limits.'">';
		echo $before_title.$title.$after_title; 
		echo '<ul>';
		echo dtheme_posts_list( $orderby,$limit);
		echo '</ul>';
		echo $after_widget;
	}

	function form( $instance ) {
?>
		<p>
			<label>
				标题：
				<input style="width:100%;" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $instance['title']; ?>" />
			</label>
		</p>
		<p>
			<label>
				排序：
				<select style="width:100%;" id="<?php echo $this->get_field_id('orderby'); ?>" name="<?php echo $this->get_field_name('orderby'); ?>" style="width:100%;">
					<option value="date" <?php selected('date', $instance['orderby']); ?>>发布时间</option>
					<option value="comment_count" <?php selected('comment_count', $instance['orderby']); ?>>评论排行</option>
					<option value="rand" <?php selected('rand', $instance['orderby']); ?>>随机</option>
				</select>
			</label>
		</p>
		<p>
			<label>
				显示数目：
				<input style="width:100%;" id="<?php echo $this->get_field_id('limit'); ?>" name="<?php echo $this->get_field_name('limit'); ?>" type="number" value="<?php echo $instance['limit']; ?>" size="24" />
			</label>
		</p>
		<p>
			<label>
				填写滑动数字：one、two、three、four、five,留空则不滑动！
				<input style="width:100%;" id="<?php echo $this->get_field_id('limits'); ?>" name="<?php echo $this->get_field_name('limits'); ?>" type="text" value="<?php echo $instance['limits']; ?>" />
			</label>
		</p>
	<?php
	}
}


function dtheme_posts_list($orderby,$limit) {
	$args = array(
		'order'            => DESC,
		'orderby'          => $orderby,
		'showposts'        => $limit,
		'caller_get_posts' => 1
	);
	query_posts($args);
	while (have_posts()) : the_post(); 
?>
<li><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a></li>
<?php
    endwhile; wp_reset_query();
}
add_action( 'widgets_init', 'd_postlists' );