<?php
/**
 * 获取文章列表
 * @param int $count 数量
 * @param null $cate 分类ID
 * @param null $auth 用户ID
 * @param null $date 日期
 * @param null $tags 标签
 * @param null $search 搜索关键词
 * @param null $order 排序
 * @param null $option
 * @return array|mixed
 */
function TcgetList($count = 10, $cate = null, $auth = null, $date = null, $tags = null, $search = null, $option = null,$order=null) {
    global $zbp;
    if (!is_array($option)) {
        $option = array();
    }
    if (!isset($option['only_ontop']))
        $option['only_ontop'] = false;
    if (!isset($option['only_not_ontop']))
        $option['only_not_ontop'] = false;
    if (!isset($option['has_subcate']))
        $option['has_subcate'] = false;
    if (!isset($option['is_related']))
        $option['is_related'] = false;
    if ($option['is_related']) {
        $at = $zbp->GetPostByID($option['is_related']);
        $tags = $at->Tags;
        if (!$tags)
            return array();
        $count = $count + 1;
    }
    if ($option['only_ontop'] == true) {
        $w[] = array('=', 'log_IsTop', 0);
    } elseif ($option['only_not_ontop'] == true) {
        $w[] = array('=', 'log_IsTop', 1);
    }
    $w = array();
    $w[] = array('=', 'log_Status', 0);
    $articles = array();
    if (!is_null($cate)) {
        $category = new Category;
        $category = $zbp->GetCategoryByID($cate);
        if ($category->ID > 0) {
            if (!$option['has_subcate']) {
                $w[] = array('=', 'log_CateID', $category->ID);
            } else {
                $arysubcate = array();
                $arysubcate[] = array('log_CateID', $category->ID);
                foreach ($zbp->categorys[$category->ID]->SubCategorys as $subcate) {
                    $arysubcate[] = array('log_CateID', $subcate->ID);
                }
                $w[] = array('array', $arysubcate);
            }
        }
    }
    if (!is_null($auth)) {
        $author = new Member;
        $author = $zbp->GetMemberByID($auth);
 
        if ($author->ID > 0) {
            $w[] = array('=', 'log_AuthorID', $author->ID);
        }
    }
    if (!is_null($date)) {
        $datetime = strtotime($date);
        if ($datetime) {
            $datetitle = str_replace(array('%y%', '%m%'), array(date('Y', $datetime), date('n', $datetime)), $zbp->lang['msg']['year_month']);
            $w[] = array('BETWEEN', 'log_PostTime', $datetime, strtotime('+1 month', $datetime));
        }
    }
    if (!is_null($tags)) {
        $tag = new Tag;
        if (is_array($tags)) {
            $ta = array();
            foreach ($tags as $t) {
                $ta[] = array('log_Tag', '%{' . $t->ID . '}%');
            }
            $w[] = array('array_like', $ta);
            unset($ta);
        } else {
            if (is_int($tags)) {
                $tag = $zbp->GetTagByID($tags);
            } else {
                $tag = $zbp->GetTagByAliasOrName($tags);
            }
            if ($tag->ID > 0) {
                $w[] = array('LIKE', 'log_Tag', '%{' . $tag->ID . '}%');
            }
        }
    }
    if (is_string($search)) {
        $search=trim($search);
        if ($search!=='') {
            $w[] = array('search', 'log_Content', 'log_Intro', 'log_Title', $search);
        }
    }    
    if(!empty($order)){
    if($order=='new'){
        $order = array('log_PostTime'=>'DESC');
    }
    if($order=='hot'){
        $order = array('log_ViewNums'=>'DESC');
    }
    if($order=='comm'){
        $order = array('log_CommNums'=>'DESC');
    }
    if($order=='rand'){
        $order = array('rand()'=>' ');
    }
    }
    $articles = $zbp->GetArticleList('*', $w, $order, $count, null, false);
    if ($option['is_related']) {
        foreach ($articles as $k => $a) {
            if ($a->ID == $option['is_related'])
                unset($articles[$k]);
        }
        if (count($articles) == $count){
            array_pop($articles);
        }
    }
    return $articles;
}

//注册插件
RegisterPlugin("wzdir","ActivePlugin_wzdir");
//具体的接口挂接
function ActivePlugin_wzdir() {
    Add_Filter_Plugin('Filter_Plugin_Edit_Response5','lezaimao_info');
    Add_Filter_Plugin('Filter_Plugin_Admin_TopMenu','lezaimao_AddMenu');
    Add_Filter_Plugin('Filter_Plugin_ViewPost_Template','lezaimao_tags_set');
}
//定义目录简介自定义文本
function lezaimao_info(){
    global $zbp,$article;   
    echo '<div class="editmod"><label for="meta_articlesinfo" class="editinputname">网站简介</label><input type="text" name="meta_articlesinfo" style="width:99%;" value="'.htmlspecialchars($article->Metas->articlesinfo).'"></div>';
    echo '<div class="editmod"><label for="meta_articlesurl" class="editinputname">网站网址</label><input type="text" name="meta_articlesurl" style="width:99%;" value="'.htmlspecialchars($article->Metas->articlesurl).'"></div>';
}

function lezaimao_AddMenu(&$m){
    global $zbp;
    array_unshift($m, MakeTopMenu("root",'乐在猫网赚导航主题配置',$zbp->host . "zb_users/theme/wzdir/main.php","","topmenu_lezaimao"));
}

function lezaimao_tags_set(&$template){
    global $zbp;
    $keywords = $description = $homedir = '';
    //keywords
    if(($zbp->Config('wzdir')->SetKeywords) != ''){
        $keywords .= "{$zbp->Config('wzdir')->SetKeywords}";
    }
    //description
    if(($zbp->Config('wzdir')->SetDescription) != ''){
        $description .= "{$zbp->Config('wzdir')->SetDescription}";
    }

    //Homedir
    if(($zbp->Config('wzdir')->SetHomeDir) != ''){
        $homedir .= "{$zbp->Config('wzdir')->SetHomeDir}";
    }
    
}

function InstallPlugin_lezaimao(){
    global $zbp;
    if(!$zbp->Config('wzdir')->HasKey('Version')){
        $zbp->Config('wzdir')->Version = '1.0';
        $zbp->Config('wzdir')->SetKeywords = '这里填写站点关键词，以逗号隔开';
        $zbp->Config('wzdir')->SetDescription = '这里填写站点描述';
        $zbp->Config('wzdir')->SetHomeDir = '这里填写首页分类ID';
        $zbp->SaveConfig('wzdir');
    }
    
}
function UninstallPlugin_lezaimao(){
    global $zbp;
    $zbp->DelConfig('wzdir');
}
?>