@extends($_viewFrame)

@section('pageTitleMain','知识产权')

@section('bodyContent')

    <div class="ub-container">

        <div class="ub-nav-header">
            知识产权
        </div>

        <div class="row">
            <div class="col-md-3">
                <div class="ub-menu simple">
                    <a class="title @if(!$categoryId) active @endif" href="{{$__msRoot}}property">全部</a>
                    @foreach($categories as $category)
                        <a class="title @if($category['id']==$categoryId) active @endif" href="{{$__msRoot}}property?categoryId={{$category['id']}}">{{$category['title']}}</a>
                    @endforeach
                </div>
            </div>
            <div class="col-md-9">
                <div class="ub-list-items">
                    <div class="row">
                        @foreach($records as $record)
                            <div class="col-md-4 col-6">
                                <div class="item-p">
                                    <a class="image" href="{{$__msRoot}}property/{{$record['id']}}">
                                        <div class="cover contain ub-cover-1-1" style="width:80%;margin:0 auto;background-image:url({{\ModStart\Core\Assets\AssetsUtil::fix($record['cover'])}});"></div>
                                    </a>
                                    <a class="title" href="{{$__msRoot}}property/{{$record['id']}}">{{$record['title']}}</a>
                                </div>
                            </div>
                        @endforeach
                    </div>
                    @if(empty($records))
                        <div class="ub-empty">
                            <div class="icon"><i class="iconfont icon-emptybox"></i></div>
                            <div class="text">暂无记录</div>
                        </div>
                    @endif
                </div>
                <div class="ub-page">
                    {!! $pageHtml !!}
                </div>
            </div>
        </div>

    </div>

@endsection





