@extends($_viewFrame)

@section('pageTitleMain',htmlspecialchars($news['title']))

{!! \ModStart\ModStart::js('asset/common/lazyLoad.js') !!}
@section('bodyContent')

    <div class="ub-container">

        <div class="ub-nav-header">
            新闻资讯
        </div>

        <div class="row">
            <div class="col-md-9">

                <div class="ub-panel margin-top" style="padding:1rem;">
                    <div class="body">
                        <div class="ub-article">
                            <h1>{{$news['title']}}</h1>
                            <div class="attr">
                                时间：{{($news['created_at'])}}
                                分类：{{$news['_category']['title']}}
                            </div>
                            <div class="content ub-html">
                                {!! \ModStart\Core\Util\HtmlUtil::replaceImageSrcToLazyLoad($news['content'],'data-src',true) !!}
                            </div>
                            <div class="ub-text-center">
                                @include('module::Vendor.View.public.shareButtons')
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <div class="col-md-3">

                <div class="ub-panel margin-top">
                    <div class="head">
                        <div class="title">
                            最近资讯
                        </div>
                    </div>
                    <div class="body ub-list-items">
                        @foreach($newsLatest as $record)
                            <a class="item-c" href="{{$__msRoot}}news/{{$record['id']}}">{{$record['title']}}</a>
                        @endforeach
                    </div>
                </div>

                @if(!empty($ads))
                    <div class="ub-panel" style="margin-top:1rem;">
                        <div class="body">
                            @foreach($ads as $ad)
                                @if($ad['link'])
                                    <a class="item" href="{{$ad['link']}}" target="_blank">
                                        <img style="width:100%;" src="{{\ModStart\Data\DataManager::fix($ad['image'])}}" />
                                    </a>
                                @else
                                    <div class="item">
                                        <img style="width:100%;" src="{{\ModStart\Data\DataManager::fix($ad['image'])}}" />
                                    </div>
                                @endif
                            @endforeach
                        </div>
                    </div>
                @endif

            </div>
        </div>

    </div>

@endsection





