@extends($_viewFrame)

@section('pageTitleMain','产品')

@section('bodyContent')

    <div class="ub-container">

        <div class="ub-nav-header">
            产品
        </div>

        <div class="row">
            <div class="col-md-3">
                <div class="ub-menu simple">
                    <a class="title @if(!$categoryId) active @endif" href="{{$__msRoot}}product">全部</a>
                    @foreach($categories as $category)
                        <a class="title @if($category['id']==$categoryId) active @endif" href="{{$__msRoot}}product?categoryId={{$category['id']}}">{{$category['title']}}</a>
                    @endforeach
                </div>
                @if(!empty($ads))
                    <div class="ub-panel" style="margin-top:1rem;">
                        <div class="body">
                            @foreach($ads as $ad)
                                @if($ad['link'])
                                    <a class="item" href="{{$ad['link']}}" target="_blank">
                                        <img style="width:100%;" src="{{\ModStart\Data\DataManager::fix($ad['image'])}}" />
                                    </a>
                                @else
                                    <div class="item">
                                        <img style="width:100%;" src="{{\ModStart\Data\DataManager::fix($ad['image'])}}" />
                                    </div>
                                @endif
                            @endforeach
                        </div>
                    </div>
                @endif
            </div>
            <div class="col-md-9">
                <div class="ub-list-items">
                    <div class="row">
                        @foreach($records as $record)
                            <div class="col-md-4 col-6">
                                <div class="item-p">
                                    <a class="image" href="{{$__msRoot}}product/{{$record['id']}}" style="padding:1rem 0 0 0;">
                                        <div class="cover contain ub-cover-1-1" style="width:80%;margin:0 auto;background-image:url({{\ModStart\Core\Assets\AssetsUtil::fix($record['cover'])}});"></div>
                                    </a>
                                    <a class="title" href="{{$__msRoot}}product/{{$record['id']}}">{{$record['title']}}</a>
                                </div>
                            </div>
                        @endforeach
                    </div>
                    @if(empty($records))
                        <div class="ub-empty">
                            <div class="icon">
                                <div class="iconfont icon-emptybox"></div>
                            </div>
                            <div class="text">暂无记录</div>
                        </div>
                    @endif
                </div>
                <div class="ub-page">
                    {!! $pageHtml !!}
                </div>
            </div>
        </div>

    </div>

@endsection





