@extends('modstart::layout.frame')

@section('pageFavIco',\ModStart\Core\Assets\AssetsUtil::fix(modstart_config('siteFavIco')))
@section('pageTitle')@yield('pageTitleMain','') - {{modstart_config('siteName')}}@endsection
@section('pageKeywords',modstart_config('siteKeywords'))
@section('pageDescription',modstart_config('pageDescription'))

@section('headAppend')
    @parent
    <link rel="stylesheet" href="{{\ModStart\Core\Assets\AssetsUtil::fix('theme/'.modstart_config('siteTemplate','default').'/css/style.css')}}"/>
    {!! modstart_config('systemCounter') !!}
    <style type="text/css">
        @if(modstart_config('sitePrimaryColor',null))
            :root{
            --theme-color-primary: {{modstart_config('sitePrimaryColor')}};
            --theme-color-primary-light: {{modstart_config('sitePrimaryColor')}};
            --theme-color-primary-dark: {{modstart_config('sitePrimaryColor')}};
        }
        @endif
    </style>
@endsection

@section('bodyAppend')
    @parent
    {!! modstart_config('systemCounterBody') !!}
@endsection

@section('body')

    <header class="ub-header">
        <div class="ub-container">
            <div class="menu-mask" onclick="$('body').removeClass('ub-header-show')"></div>
            <div class="menu">
                @foreach(\Module\Nav\Util\NavUtil::listByPositionWithCache('head') as $item)
                    <a href="{{$item['link']}}">{{$item['name']}}</a>
                @endforeach
            </div>
            <a class="menu-toggle" href="javascript:;" onclick="$('body').toggleClass('ub-header-show')">
                <i class="show iconfont icon-list"></i>
                <i class="close iconfont icon-close"></i>
            </a>
            <div class="logo">
                <a href="/">
                    <img src="{{\ModStart\Core\Assets\AssetsUtil::fix(modstart_config('siteLogo'))}}" />
                </a>
            </div>
        </div>
    </header>

    @section('bodyContent')
    @show

    <footer class="ub-footer">
        <div class="ub-container">
            <div class="line"></div>
            <div class="nav">
                @foreach(\Module\Article\Util\ArticleUtil::listByPositionWithCache('footer') as $footerArticle)
                    <a href="/article/{{$footerArticle['id']}}">{{$footerArticle['title']}}</a>
                @endforeach
            </div>
            <div class="copyright">
                <a href="http://beian.miit.gov.cn" target="_blank">{{modstart_config('siteBeian','[网站备案信息]')}}</a>
                &copy;{{modstart_config('siteDomain')}}
            </div>
        </div>
    </footer>

    @include('module::ServiceBar.View.pc.share.sidebar')

@endsection
