@extends($_viewFrame)

@section('pageTitle',modstart_config('siteName').' - '.modstart_config('siteSlogan'))

@section('bodyContent')

    <div style="background:#FFF;">
        <div class="ub-container">
            @include('module::Banner.View.pc.public.banner',['position'=>'home','bannerRatio'=>'5-2'])
        </div>
    </div>

    <div class="ub-container margin-top">
        <div class="row">
            <div class="col-md-8">
                <div class="ub-panel">
                    <div class="head">
                        <div class="title">公司介绍</div>
                    </div>
                    <div class="body">
                        <div class="ub-html">{!! modstart_config('siteAboutHome') !!}</div>
                    </div>
                </div>
                @include('module::Product.View.pc.public.listLatest')
            </div>
            <div class="col-md-4">
                @include('module::News.View.pc.public.listLatest')
                <div class="ub-panel">
                    <div class="head">
                        <div class="title">联系我们</div>
                    </div>
                    <div class="body">
                        <div class="ub-pair">
                            <div class="name"><i class="iconfont icon-address"></i> 地址</div>
                            <div class="value">{{modstart_config('contactAddress')}}</div>
                        </div>
                        <div class="ub-pair">
                            <div class="name"><i class="iconfont icon-1101dianhua"></i> 电话</div>
                            <div class="value">{{modstart_config('contactTel')}}</div>
                        </div>
                        <div class="ub-pair">
                            <div class="name"><i class="iconfont icon-email"></i> 邮箱</div>
                            <div class="value">{{modstart_config('contactEmail')}}</div>
                        </div>
                        <div class="ub-pair">
                            <div class="name"><i class="iconfont icon-qq-copy" style="transform:scale(1.4);display:inline-block;"></i> QQ</div>
                            <div class="value">{{modstart_config('contactQQ')}}</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @include('module::Partner.View.pc.public.partner',['position'=>'home','bannerRatio'=>'3-1'])
    </div>

@endsection