<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace ModStart\Form; use Closure; use Illuminate\Contracts\Support\Renderable; use Illuminate\Database\Eloquent\Model; use Illuminate\Support\Collection; use Illuminate\Support\Facades\Input; use Illuminate\Validation\Validator; use ModStart\Core\Dao\DynamicModel; use ModStart\Core\Exception\BizException; use ModStart\Core\Exception\ResultException; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Response; use ModStart\Core\Type\SortDirection; use ModStart\Core\Util\IdUtil; use ModStart\Field\AbstractField; use ModStart\Field\AutoRenderedFieldValue; use ModStart\Field\Display; use ModStart\Field\Select; use ModStart\Field\Type\FieldRenderMode; use ModStart\Form\Concern\HasCascadeFields; use ModStart\Form\Type\FormEngine; use ModStart\Form\Type\FormMode; use ModStart\Grid\Concerns\HasSort; use ModStart\Repository\Repository; use ModStart\Repository\RepositoryUtil; use ModStart\Support\Concern\HasBuilder; use ModStart\Support\Concern\HasFields; use ModStart\Support\Concern\HasFluentAttribute; use ModStart\Support\Manager\FieldManager; class Form implements Renderable { use HasFields, HasBuilder, HasFluentAttribute, HasSort, HasCascadeFields; private $id; private $repository; private $view = 'modstart::core.form.index'; protected $fluentAttributes = array('engine', 'builder', 'mode', 'title', 'showSubmit', 'showReset', 'itemId', 'item', 'hookSubmitted', 'hookSaving', 'hookSaved', 'hookDeleting', 'hookDeleted', 'hookChanged', 'dataSubmitted', 'dataForming', 'dataAdding', 'dataEditing', 'canAdd', 'canEdit', 'canDelete', 'canSort', 'formClass', 'treeMaxLevel', 'treeRootPid'); private $engine = 'basic'; private $mode = 'form'; private $title; private $showSubmit = true; private $showReset = true; private $itemId = null; private $item; private $hookSubmitted; private $hookSaving; private $hookSaved; private $hookDeleting; private $hookDeleted; private $hookChanged; private $dataSubmitted; private $dataForming; private $dataAdding; private $dataEditing; private $canAdd = true; private $canEdit = true; private $canDelete = true; private $canSort = false; private $formClass = ''; private $treeMaxLevel = 0; private $treeRootPid = 0; public function __construct($a_UAg, \Closure $fb3zO = null) { goto XMvwd; aRXYh: $this->setupFields(); goto wFL3q; wFL3q: $this->fieldDefaultRenderMode(FieldRenderMode::FORM); goto SXR_a; rLTan: $this->repository = Repository::instance($a_UAg); goto aRXYh; XMvwd: $this->id = IdUtil::generate('Grid'); goto rLTan; SXR_a: $this->builder($fb3zO); goto MFDYa; MFDYa: } public static function make($pWRTh, \Closure $fb3zO = null) { if (class_exists($pWRTh) && is_subclass_of($pWRTh, \Illuminate\Database\Eloquent\Model::class)) { return new Form($pWRTh, $fb3zO); } return new Form(DynamicModel::make($pWRTh), $fb3zO); } public function asTree($kkQsP = 'id', $b_wxs = 'pid', $uY1vf = 'sort', $ysr4x = 'title') { goto lOdGZ; MEdOg: $this->engine = FormEngine::TREE; goto O6PeR; yUC70: return $this; goto cA_t3; ILfqP: $this->repository->setTreeTitleColumn($ysr4x); goto MEdOg; muJjx: $this->repository->setSortColumn($uY1vf); goto ILfqP; lOdGZ: $this->repository->setKeyName($kkQsP); goto efePd; O6PeR: $this->canSort(true); goto yUC70; efePd: $this->repository->setTreePidColumn($b_wxs); goto muJjx; cA_t3: } public function asTreeMass($IV7Lu = 0, $kkQsP = 'id', $b_wxs = 'pid', $uY1vf = 'sort', $ysr4x = 'title') { goto nPTr9; evIr_: $this->repository->setTreeTitleColumn($ysr4x); goto RS02U; lxNM6: $this->repository->setSortColumn($uY1vf); goto evIr_; RS02U: $this->engine = FormEngine::TREE_MASS; goto BbjEX; ZaDFC: $this->repository->setTreePidColumn($b_wxs); goto lxNM6; BbjEX: $this->canSort(true); goto iJvIh; nPTr9: $this->repository->setKeyName($kkQsP); goto ZaDFC; iJvIh: return $this; goto ya_2R; ya_2R: } private function build() { $this->runBuilder(); if ($this->engine == FormEngine::TREE) { if ($this->treeMaxLevel > 1) { $Q2vn5 = FieldManager::make($this, 'select', $this->repository->getTreePidColumn(), L('Parent')); $Q2vn5->optionRepositoryTreeItems($this->repository, $this->treeMaxLevel); } else { $Q2vn5 = FieldManager::make($this, 'hidden', $this->repository->getTreePidColumn(), L('Parent')); $Q2vn5->value(0); } $this->prependField($Q2vn5); } else { if ($this->engine == FormEngine::TREE_MASS) { goto LB0qj; LB0qj: $Q2vn5 = FieldManager::make($this, 'display', $this->repository->getTreePidColumn(), L('Parent')); goto cCNjU; vvnRB: $this->prependField($Q2vn5); goto DyNGJ; HNC1K: $Q2vn5->hookRendering(function (AbstractField $Q2vn5, $Nrp0b, $XIWRg) { if (empty($Nrp0b)) { $cnx4c = InputPackage::buildFromInput()->get('_pid', $this->treeRootPid); } else { $cnx4c = $Nrp0b->{$this->repository->getTreePidColumn()}; } $this->repository()->setArgument('treePid', $cnx4c); $bPoVK = $this->repository->getTreeAncestorItems(); $B8MP1 = array(); $B8MP1[] = '<span class="ub-text-muted"><i class="icon iconfont icon-angle2"></i></span> ' . L('Root'); foreach ($bPoVK as $L_7ar) { $B8MP1[] = '<span class="ub-text-muted"><i class="icon iconfont icon-angle2"></i></span> ' . htmlspecialchars($L_7ar->{$this->repository->getTreeTitleColumn()}); } $B8MP1[] = '<input type="hidden" name="' . $this->repository->getTreePidColumn() . '" value="' . htmlspecialchars($cnx4c) . '" />'; return AutoRenderedFieldValue::make(join('', $B8MP1)); }); goto vvnRB; cCNjU: $Q2vn5->addable(true)->editable(true)->listable(false); goto HNC1K; DyNGJ: } } } public function repository() { return $this->repository; } private function fieldValidateMessages($cCRbx, $R4txz) { goto ZDOZX; ZDOZX: $jBKOP = array(); goto CxF7h; KuC_I: foreach ($jBKOP as $h8xsU) { foreach ($h8xsU->messages()->getMessages() as $JNXBz => $tjmAU) { $KSpj7[$JNXBz] = $tjmAU; } } goto XPpka; AuqRB: $KSpj7 = array(); goto KuC_I; jriuQ: return $KSpj7; goto uw5kM; CxF7h: foreach ($cCRbx as $Q2vn5) { if (!($h8xsU = $Q2vn5->getValidator($R4txz))) { continue; } if ($h8xsU instanceof Validator && !$h8xsU->passes()) { $jBKOP[] = $h8xsU; } } goto AuqRB; XPpka: if (empty($KSpj7)) { return false; } goto jriuQ; uw5kM: } private function validateFields($cCRbx, $Y0YxF) { goto iazJ6; iazJ6: $C3nfn = array(); goto W8Rre; dVP0C: return Response::generateSuccess(); goto Kgh1d; FxK1z: foreach ($C3nfn as $JNXBz => $KSpj7) { foreach ($KSpj7 as $BDJuO) { return Response::generateError($BDJuO); } } goto dVP0C; W8Rre: if ($XYt9D = $this->fieldValidateMessages($this->editableFields(), $this->dataSubmitted)) { $C3nfn = array_merge($C3nfn, $XYt9D); } goto FxK1z; Kgh1d: } private function removeReservedFields() { goto DpytU; DpytU: $rhNnR = array($this->repository->getKeyName(), $this->repository->getCreatedAtColumn(), $this->repository->getUpdatedAtColumn()); goto YMqqv; YMqqv: $b3gKI = function (AbstractField $Q2vn5) use(&$rhNnR) { return in_array($Q2vn5->column(), $rhNnR, true) && $Q2vn5 instanceof \ModStart\Field\Display; }; goto mVunc; mVunc: $this->fields = $this->fields()->reject($b3gKI); goto QjbyQ; QjbyQ: } public function hookCall($l2aoe) { if ($l2aoe instanceof Closure) { $uotzZ = call_user_func($l2aoe, $this); if (null !== $uotzZ) { return $uotzZ; } } return Response::generateSuccess(); } public function isModeForm() { return $this->mode === FormMode::FORM; } public function isModeAdd() { return $this->mode === FormMode::ADD; } public function isModeEdit() { return $this->mode === FormMode::EDIT; } public function isModeDelete() { return $this->mode === FormMode::DELETE; } public function formRequest($l2aoe, array $Y0YxF = null) { goto NXYIh; pttHn: try { goto rJS_h; Iaf93: foreach ($this->addableFields() as $Q2vn5) { goto JJcNa; kvx1H: $tzAUI = $Q2vn5->serializeValue($tzAUI, $Q2vn5); goto HG6c_; JfVS9: $this->dataForming[$Q2vn5->column()] = $tzAUI; goto ndS5z; Sqq08: $tzAUI = isset($this->dataSubmitted[$Q2vn5->column()]) ? $this->dataSubmitted[$Q2vn5->column()] : null; goto a00iF; JJcNa: if ($Q2vn5->isLayoutField()) { continue; } goto Sqq08; HG6c_: if ($Q2vn5->hookValueSerialize()) { $tzAUI = call_user_func($Q2vn5->hookValueSerialize(), $tzAUI, $Q2vn5); } goto JfVS9; a00iF: $tzAUI = $Q2vn5->prepareInput($tzAUI, $this->dataSubmitted); goto kvx1H; ndS5z: } goto mh_CM; ycE33: ResultException::throwsIfFail($this->hookCall($this->hookChanged)); goto aVpeS; Wvi0W: ResultException::throwsIfFail($this->hookCall($this->hookSubmitted)); goto wXmtj; H0GZW: if (null !== $uotzZ) { if (Response::isError($uotzZ)) { return Response::jsonFromGenerate($uotzZ); } } goto ndBOE; aVpeS: if (null !== $uotzZ) { return Response::jsonFromGenerate($uotzZ); } goto MgeDO; MgeDO: if (!empty($this->dataSubmitted['_redirect'])) { return Response::json(0, null, null, $this->dataSubmitted['_redirect']); } goto M34RK; M34RK: return Response::jsonSuccess(L('Save Success')); goto qweMp; ndBOE: ResultException::throwsIfFail($this->hookCall($this->hookSaved)); goto ycE33; rJS_h: ResultException::throwsIfFail($this->validateFields($this->addableFields(), $this->dataSubmitted)); goto Wvi0W; oKK2e: $this->removeReservedFields(); goto Iaf93; xYtiy: $uotzZ = call_user_func($l2aoe, $this); goto H0GZW; mh_CM: ResultException::throwsIfFail($this->hookCall($this->hookSaving)); goto xYtiy; wXmtj: $this->dataForming = array(); goto oKK2e; qweMp: } catch (BizException $vBRkZ) { return Response::jsonError($vBRkZ->getMessage()); } catch (ResultException $vBRkZ) { return Response::jsonError($vBRkZ->getMessage()); } goto J67nk; NXYIh: $this->mode(FormMode::FORM); goto Edch1; ETkuy: $this->dataSubmitted = $Y0YxF ? $Y0YxF : Input::all(); goto pttHn; Edch1: $this->build(); goto ETkuy; J67nk: } public function add() { goto ZOhm9; jrXLa: return $this; goto ARZsr; qI1pp: $this->build(); goto jrXLa; ZOhm9: $this->mode(FormMode::ADD); goto qI1pp; ARZsr: } public function addRequest(array $Y0YxF = null) { goto fmI6M; Gomiq: try { goto wDFbY; S5guF: $this->removeReservedFields(); goto PBCxv; F9k6m: if (!empty($this->dataSubmitted['_redirect'])) { return Response::json(0, null, null, $this->dataSubmitted['_redirect']); } goto MAtjH; F7mcp: $this->dataAdding = array(); goto S5guF; PBCxv: foreach ($this->addableFields() as $Q2vn5) { goto HY2Pp; qEGIr: $tzAUI = isset($this->dataSubmitted[$Q2vn5->column()]) ? $this->dataSubmitted[$Q2vn5->column()] : null; goto mayOs; mayOs: $tzAUI = $Q2vn5->prepareInput($tzAUI, $this->dataSubmitted); goto BJynH; m3_fb: $this->dataAdding[$Q2vn5->column()] = $tzAUI; goto x2tcr; BJynH: $tzAUI = $Q2vn5->serializeValue($tzAUI, $Q2vn5); goto W0_oE; HY2Pp: if ($Q2vn5->isLayoutField() || $Q2vn5->isCustomField()) { continue; } goto qEGIr; W0_oE: if ($Q2vn5->hookValueSerialize()) { $tzAUI = call_user_func($Q2vn5->hookValueSerialize(), $tzAUI, $Q2vn5); } goto m3_fb; x2tcr: } goto EGNhP; wDFbY: ResultException::throwsIfFail($this->validateFields($this->addableFields(), $this->dataSubmitted)); goto GH4RB; EGNhP: $UFOLC = $this->repository->add($this); goto F9k6m; GH4RB: ResultException::throwsIfFail($this->hookCall($this->hookSubmitted)); goto F7mcp; MAtjH: return Response::jsonSuccess(L('Add Success')); goto yPIVR; yPIVR: } catch (BizException $vBRkZ) { return Response::jsonError($vBRkZ->getMessage()); } catch (ResultException $vBRkZ) { return Response::jsonError($vBRkZ->getMessage()); } goto k90wR; eBN3I: $this->mode(FormMode::ADD); goto cSfG1; fmI6M: if (!$this->canAdd) { return Response::pagePermissionDenied(); } goto eBN3I; cSfG1: $this->build(); goto lxXU7; lxXU7: $this->dataSubmitted = $Y0YxF ? $Y0YxF : Input::all(); goto Gomiq; k90wR: } public function edit($UFOLC) { try { goto cn8ZB; ux1KS: $this->fillFields(); goto slvs7; cn8ZB: $this->mode(FormMode::EDIT); goto DlovP; DlovP: $this->itemId($UFOLC); goto SP7r6; SP7r6: $this->item($this->repository()->editing($this)); goto UkLs1; UkLs1: BizException::throwsIfEmpty(L('Record Not Exists'), $this->item); goto h7K6A; slvs7: return $this; goto hxIGd; h7K6A: $this->build(); goto ux1KS; hxIGd: } catch (BizException $vBRkZ) { return Response::sendError($vBRkZ->getMessage()); } } public function editRequest($UFOLC, array $Y0YxF = null) { goto gqxBq; NmaeR: $this->dataSubmitted = $Y0YxF ? $Y0YxF : Input::all(); goto bss4R; bss4R: try { goto aG27z; f9kuD: ResultException::throwsIfFail($this->hookCall($this->hookSubmitted)); goto Agm1x; aG27z: $this->edit($UFOLC); goto JHEnG; GV_3V: $this->repository()->edit($this); goto Owsye; k0Ww1: foreach ($this->editableFields() as $Q2vn5) { goto Q6mIV; bSUGi: $tzAUI = $Q2vn5->prepareInput($tzAUI, $this->dataSubmitted); goto gmhEm; qraOv: $this->dataEditing[$Q2vn5->column()] = $tzAUI; goto KNKRj; Ot3zd: if ($Q2vn5->hookValueSerialize()) { $tzAUI = call_user_func($Q2vn5->hookValueSerialize(), $tzAUI, $Q2vn5); } goto qraOv; gmhEm: $tzAUI = $Q2vn5->serializeValue($tzAUI, $Q2vn5); goto Ot3zd; Q6mIV: if ($Q2vn5->isLayoutField() || $Q2vn5->isCustomField()) { continue; } goto G3NcB; G3NcB: $tzAUI = isset($this->dataSubmitted[$Q2vn5->column()]) ? $this->dataSubmitted[$Q2vn5->column()] : null; goto bSUGi; KNKRj: } goto GV_3V; pf87p: $this->removeReservedFields(); goto k0Ww1; psNXm: return Response::jsonSuccess(L('Edit Success')); goto oyv6k; Agm1x: $this->dataEditing = array(); goto pf87p; Owsye: if (!empty($this->dataSubmitted['_redirect'])) { return Response::json(0, null, null, $this->dataSubmitted['_redirect']); } goto psNXm; JHEnG: ResultException::throwsIfFail($this->validateFields($this->editableFields(), $this->dataSubmitted)); goto f9kuD; oyv6k: } catch (BizException $vBRkZ) { return Response::jsonError($vBRkZ->getMessage()); } catch (ResultException $vBRkZ) { return Response::jsonError($vBRkZ->getMessage()); } goto tdKSc; gqxBq: if (!$this->canEdit) { return Response::pagePermissionDenied(); } goto NmaeR; tdKSc: } public function deleteRequest($a3gf2) { goto JAqWT; p3LZn: $this->itemId($a3gf2); goto iXPIv; mnhOK: try { goto QK5Do; Sdmzd: return Response::jsonSuccess(L('Delete Success')); goto qXmcG; kl5VO: $this->itemId(collect($Y0YxF)->map(function ($bPX0o) { return $bPX0o->{$this->repository()->getKeyName()}; })->toArray()); goto N1oqd; QK5Do: $Y0YxF = $this->repository->deleting($this); goto s13td; s13td: $this->item($Y0YxF); goto kl5VO; N1oqd: $yw7NX = $this->repository->delete($this, $Y0YxF); goto Sdmzd; qXmcG: } catch (BizException $vBRkZ) { return Response::jsonError($vBRkZ->getMessage()); } catch (ResultException $vBRkZ) { return Response::jsonError($vBRkZ->getMessage()); } goto IrTdm; JAqWT: if (!$this->canDelete) { return Response::pagePermissionDenied(); } goto qzFs4; iXPIv: $this->build(); goto mnhOK; qzFs4: $this->mode(FormMode::DELETE); goto p3LZn; IrTdm: } public function sortRequest($a3gf2) { goto k3lRg; maLP1: try { goto l66El; YEg3a: ResultException::throwsIfFail($this->hookCall($this->hookChanged)); goto IrG7c; l66El: $yw7NX = $this->repository->sortEdit($this); goto YEg3a; IrG7c: return Response::jsonSuccess(L('Operate Success')); goto VeeHT; VeeHT: } catch (BizException $vBRkZ) { return Response::jsonError($vBRkZ->getMessage()); } catch (ResultException $vBRkZ) { return Response::jsonError($vBRkZ->getMessage()); } goto Thm9j; D3Nmb: $this->mode(FormMode::SORT); goto agrJ2; y3Ur0: $this->build(); goto maLP1; sBWTM: $this->repository->setArgument('direction', $R4txz->getType('direction', SortDirection::class)); goto y3Ur0; agrJ2: $this->itemId($a3gf2); goto HlIf0; HlIf0: $R4txz = InputPackage::buildFromInput(); goto sBWTM; k3lRg: if (!$this->canSort) { return Response::pagePermissionDenied(); } goto D3Nmb; Thm9j: } public function render() { goto dAXBp; dAXBp: $Y0YxF = array(); goto no1Iv; eHsUf: return view($this->view, $Y0YxF)->render(); goto imdSX; G1EGm: $Y0YxF = array_merge($this->fluentAttributeVariables(), $Y0YxF); goto eHsUf; no1Iv: switch ($this->mode) { case FormMode::FORM: $Y0YxF['fields'] = $this->addableFields(); break; case FormMode::ADD: goto CmU2R; Qshq2: $Y0YxF['fields'] = $this->addableFields(); goto bgbgI; bgbgI: break; goto SOeyX; CmU2R: if (!$this->canAdd) { return Response::pagePermissionDenied(); } goto Qshq2; SOeyX: case FormMode::EDIT: goto Vus3R; Vus3R: if (!$this->canEdit) { return Response::pagePermissionDenied(); } goto nK7QI; vVu9l: break; goto H59r1; nK7QI: $Y0YxF['fields'] = $this->editableFields(); goto vVu9l; H59r1: default: return Response::sendError('Form.render mode error : ' . $this->mode); } goto G1EGm; imdSX: } public function __call($WIVcd, $MVaFK) { goto Xu2YA; UN05v: return FieldManager::call($this, $WIVcd, $MVaFK); goto zed7D; Xu2YA: switch ($WIVcd) { case 'enablePagination': case 'defaultOrder': case 'canShow': case 'canBatchDelete': case 'canMultiSelectItem': case 'addBlankPage': case 'editBlankPage': case 'disableCUD': case 'hookItemOperateRendering': case 'addDialogSize': case 'editDialogSize': return $this; } goto V9qhc; V9qhc: if ($this->isFluentAttribute($WIVcd)) { return $this->fluentAttribute($WIVcd, $MVaFK); } goto UN05v; zed7D: } }