<div class="line" id="{{$id}}">
    <div class="label">
        {!! str_contains($rules,'required')?'<span class="ub-text-danger ub-text-bold">*</span>':'' !!}
        {{$label}}:
    </div>
    <div class="field">
        <input type="hidden"
               {{$readonly?'readonly':''}}
               class="form"
               name="{{$name}}"
               placeholder="{{$placeholder}}"
               value="{{json_encode($value)}}"/>
        <div class="ub-images-selector">
            <div class="item">
                <div class="tools">
                    <a href="javascript:;" class="action close" data-close><i class="iconfont icon-close"></i></a>
                    <a href="javascript:;" class="action preview" data-preview><i class="iconfont icon-eye1"></i></a>
                </div>
                <div class="cover ub-cover-1-1" data-background-src="placeholder/500x500"></div>
            </div>
            <div class="item">
                <div class="tools">
                    <a href="javascript:;" class="action close" data-close><i class="iconfont icon-close"></i></a>
                    <a href="javascript:;" class="action preview" data-preview><i class="iconfont icon-eye1"></i></a>
                </div>
                <div class="cover ub-cover-1-1" data-background-src="placeholder/500x500"></div>
            </div>
            <div class="item add">
                <a href="javascript:;" class="action add" data-add><i class="iconfont icon-plus1"></i></a>
            </div>
        </div>
        @if(!empty($help))
            <div class="help">{!! $help !!}</div>
        @endif
    </div>
</div>
<script>
    $(function () {
        var $field = $('#{{$id}}');
        var $input = $field.find('input');
        var $selector = $field.find('.ub-images-selector');
        var images = [];
        try {
            images = JSON.parse($input.val());
        } catch (e) {
        }
        if(!images){
            images = [];
        }
        var render = function(){
            $selector.html('');
            var templateHtml = $field.find('[data-item-template]').html();
            var $item;
            for(var i =0;i<images.length;i++){
                $item = $('<div class="item" data-index="'+i+'">' +
                    '            <div class="tools">' +
                    '                <a href="javascript:;" class="action close" data-close><i class="iconfont icon-close"></i></a>' +
                    '                <a href="javascript:;" class="action preview" data-preview data-image-preview="'+images[i]+'"><i class="iconfont icon-eye1"></i></a>' +
                    '            </div>' +
                    '            <div class="cover ub-cover-1-1" style="background-image:url('+images[i]+');"></div>' +
                    '        </div>');
                $selector.append($item);
            }
            $selector.append('<div class="item add">' +
                '                <a href="javascript:;" class="action add" data-add><i class="iconfont icon-plus1"></i></a>' +
                '            </div>');
            $input.val(JSON.stringify(images));
        };
        render();
        $selector.on('click','[data-add]',function(){
            window.__selectorDialog = new window.api.selectorDialog({
                server: '{{$server}}/image',
                callback: function (items) {
                    if (items.length > 0) {
                        images.push(items[0].path);
                        render();
                    }
                }
            }).show();
            return false;
        });
        $selector.on('click','[data-close]',function(){
            var index = parseInt($(this).closest('[data-index]').attr('data-index'));
            images.splice(index,1);
            render();
            return false;
        });
    });
</script>