<div class="line">
    <div class="label">
        {!! str_contains($rules,'required')?'<span class="ub-text-danger ub-text-bold">*</span>':'' !!}
        {{$label}}:
    </div>
    <div class="field">
        <div id="{{$id}}Input">
            <input type="hidden" name="{{$name}}" :value="jsonValue" />
            <el-table
                    :data="value" size="mini" border
                    style="width:100%;margin:0;border-radius:3px;">
                <el-table-column width="200" label="{{L('Key')}}">
                    <template slot-scope="scope">
                        <input type="text" v-model="scope.row.{{$keyLabel}}" />
                    </template>
                </el-table-column>
                <el-table-column label="{{L('Value')}}">
                    <template slot-scope="scope">
                        <input type="text" v-model="scope.row.{{$valueLabel}}" />
                    </template>
                </el-table-column>
                <el-table-column width="50"  align="center">
                    <template slot-scope="scope">
                        <a href="javascript:;" class="ub-text-danger" @click="value.splice(scope.$index,1)"><i class="iconfont icon-trash"></i></a>
                    </template>
                </el-table-column>
            </el-table>
            <a href="javascript:;" class="ub-text-muted" @click="value.push({ :''})"><i class="iconfont icon-plus1"></i> {{L('Add')}}</a>
        </div>
        @if(!empty($help))
            <div class="help">{!! $help !!}</div>
        @endif
    </div>
</div>
<script>
    {{ \ModStart\ModStart::js('asset/vendor/vue.js') }}
    {{ \ModStart\ModStart::js('asset/vendor/element-ui/index.js') }}
    {{ \ModStart\ModStart::css('asset/vendor/element-ui/index.css') }}
    $(function () {
        var app = new Vue({
            el: '#{{$id}}Input',
            data: {
                value: {!! json_encode($value) !!}
            },
            computed:{
                jsonValue:function(){
                    return JSON.stringify(this.value);
                }
            },
            methods:{

            }
        });
    });
</script>
